/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.rocketmq;

import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.ocp.taskcore.consumer.ConsumerNode;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.message.MessageStatus;
import com.efuture.omd.storage.FStorageOperations;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.starter.core.RocketMQTemplate;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class RocketMqMessageHandle
implements IMessageHandle {
    private static Logger logger = Logger.getLogger(RocketMqMessageHandle.class);
    public static final String StorageOperation = "StorageOperation_task";
    public static final String message_tablename = "task_message";
    public static final String message_success_tablename = "task_message_success";
    public static final String message_error_tablename = "task_message_error";
    @Resource
    private RocketMQTemplate rocketMQTemplate;

    public FStorageOperations getStorageOperations() {
        return (FStorageOperations)SpringBeanFactory.getBean((String)StorageOperation, FStorageOperations.class);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public int produce(Message msg) {
        boolean ibRetry = false;
        if (MessageStatus.RETRY.name().equals(msg.getStatus())) {
            ibRetry = true;
        }
        msg.setId(UniqueID.getUniqueID());
        msg.setCreatedate(new Date());
        msg.setStatus(MessageStatus.NEW.name());
        msg.setKeyvalue(msg.getTopic() + "-" + msg.getKeyvalue());
        long stime = System.currentTimeMillis();
        try {
            ServiceLogs.logSendMqStart((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)"");
            SendResult sr = this.rocketMQTemplate.syncSend(msg.getTopic() + ":" + msg.getEvent(), MessageBuilder.withPayload((Object)msg).setHeader("KEYS", (Object)msg.getKeyvalue()).build());
            ServiceLogs.logSendMqSuccess((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)sr.toString(), (String)"", (long)stime);
            return 0;
        }
        catch (Exception e) {
            ServiceLogs.logSendMqError((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)"1.1", (String)("\u53d1\u9001\u5931\u8d25\uff0c\u540e\u7eed\u4fdd\u5b58\u5230\u6570\u636e\u5e93-->" + e.getMessage()), (String)"", (long)stime);
            msg.setMsg(e.getMessage());
            if (!ibRetry) {
                this.insdb(msg, stime);
            }
            return -1;
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public void insdb(Message msg, long stime) {
        try {
            this.getStorageOperations().insert((Object)msg, message_tablename);
        }
        catch (Exception e) {
            msg.setMsg(e.getMessage());
            msg.setData("");
            ServiceLogs.logSendMqError((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)"1.2", (String)"\u4fdd\u5b58\u6570\u636e\u5e93\u5931\u8d25,\u8bf7\u624b\u5de5\u53d1\u9001", (String)msg.getMsg(), (long)stime);
        }
    }

    public List<Message> pullNewMessage(ConsumerNode node) {
        logger.warn((Object)"rocketmq \u4e0d\u652f\u6301 pullNewMessage");
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public void consumeCallbackMessage(ConsumerNode node, Message msg) {
        if (msg == null) {
            return;
        }
        try {
            msg.setData("");
            if (!msg.getStatus().equalsIgnoreCase(MessageStatus.FAIL.name())) {
                this.getStorageOperations().insert((Object)msg, message_success_tablename);
            } else {
                this.getStorageOperations().insert((Object)msg, message_error_tablename);
            }
        }
        catch (Exception e) {
            msg.setMsg(e.getMessage());
            ServiceLogs.logConsumeMqError((String)msg.getTopic(), (String)msg.getKeyvalue(), (String)"2.1", (String)("\u6d88\u606f\u56de\u8c03,\u4fdd\u5b58\u5230\u6570\u636e\u5e93\u5931\u8d25:" + e.getMessage()), (long)msg.getExecdate().getTime());
        }
    }
}

