/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.omd.storage;

import com.efuture.omd.storage.FStorageLogger;
import com.efuture.omd.storage.FStorageOperations;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class FMongoTemplate
extends MongoTemplate
implements FStorageOperations {
    private FStorageLogger logger = new FStorageLogger();

    public FMongoTemplate(Mongo mongo, String databaseName) {
        super((MongoDbFactory)new SimpleMongoDbFactory(mongo, databaseName), null);
    }

    public FMongoTemplate(Mongo mongo, String databaseName, UserCredentials userCredentials) {
        super((MongoDbFactory)new SimpleMongoDbFactory(mongo, databaseName, userCredentials));
    }

    public FMongoTemplate(MongoDbFactory mongoDbFactory) {
        super(mongoDbFactory, null);
    }

    public FMongoTemplate(MongoDbFactory mongoDbFactory, MongoConverter mongoConverter) {
        super(mongoDbFactory, mongoConverter);
    }

    public void setWriteResultMode(String writeResultMode) {
        if ("None".equalsIgnoreCase(writeResultMode)) {
            this.setWriteResultChecking(WriteResultChecking.NONE);
        } else if ("Exception".equalsIgnoreCase(writeResultMode)) {
            this.setWriteResultChecking(WriteResultChecking.EXCEPTION);
        } else if ("Log".equalsIgnoreCase(writeResultMode)) {
            this.setWriteResultChecking(WriteResultChecking.LOG);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass) {
        return (T)this.findOne(query, entityClass);
    }

    @Override
    public <T> T selectOne(Query query, Class<T> entityClass, String tableName) {
        return this.findOne(query, entityClass, tableName);
    }

    @Override
    public Map<String, Object> selectOne(Query query, String tableName) {
        BasicDBObject obj = this.findOne(query, BasicDBObject.class, tableName);
        if (obj == null) {
            return null;
        }
        obj.remove((Object)"_id");
        return obj;
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass) {
        return this.find(query, entityClass);
    }

    @Override
    public <T> List<T> select(Query query, Class<T> entityClass, String tableName) {
        return this.find(query, entityClass, tableName);
    }

    @Override
    public List<Map<String, Object>> select(Query query, String tableName) {
        List<BasicDBObject> lst = this.find(query, BasicDBObject.class, tableName);
        if (lst == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (BasicDBObject obj : lst) {
            obj.remove((Object)"_id");
            list.add((Map<String, Object>)obj);
        }
        return list;
    }

    @Override
    public long count(Query query, Class<?> entityClass) {
        return super.count(query, entityClass);
    }

    @Override
    public long count(Query query, String tableName) {
        return super.count(query, tableName);
    }

    @Override
    public void insert(Object objectToSave) {
        super.insert(objectToSave);
    }

    @Override
    public void insert(Object objectToSave, String tableName) {
        super.insert(objectToSave, tableName);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, Class<?> entityClass) {
        super.insert(batchToSave, entityClass);
    }

    @Override
    public void insert(Collection<? extends Object> batchToSave, String tableName) {
        super.insert(batchToSave, tableName);
    }

    @Override
    public void insertAll(Collection<? extends Object> objectsToSave) {
        super.insertAll(objectsToSave);
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass) {
        WriteResult wr = this.upsert(query, update, entityClass);
        if (wr == null) {
            return -1;
        }
        return wr.getN();
    }

    @Override
    public int updateOrInsert(Query query, Update update, String tableName) {
        WriteResult wr = this.upsert(query, update, tableName);
        if (wr == null) {
            return -1;
        }
        return wr.getN();
    }

    @Override
    public int updateOrInsert(Query query, Update update, Class<?> entityClass, String tableName) {
        WriteResult wr = this.upsert(query, update, entityClass, tableName);
        if (wr == null) {
            return -1;
        }
        return wr.getN();
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass) {
        WriteResult wr = this.updateMulti(query, update, entityClass);
        if (wr == null) {
            return -1;
        }
        return wr.getN();
    }

    @Override
    public int update(Query query, Update update, String tableName) {
        WriteResult wr = this.updateMulti(query, update, tableName);
        if (wr == null) {
            return -1;
        }
        return wr.getN();
    }

    @Override
    public int update(Query query, Update update, Class<?> entityClass, String tableName) {
        WriteResult wr = this.updateMulti(query, update, entityClass, tableName);
        if (wr == null) {
            return -1;
        }
        return wr.getN();
    }

    @Override
    public int delete(Object object) {
        this.remove(object);
        return -1;
    }

    @Override
    public int delete(Object object, String tableName) {
        this.remove(object, tableName);
        return -1;
    }

    @Override
    public int delete(Query query, Class<?> entityClass) {
        this.remove(query, entityClass);
        return -1;
    }

    @Override
    public int delete(Query query, Class<?> entityClass, String tableName) {
        this.remove(query, entityClass, tableName);
        return -1;
    }

    @Override
    public int delete(Query query, String tableName) {
        this.remove(query, tableName);
        return -1;
    }

    public <T> T findOne(Query query, Class<T> entityClass, String collectionName) {
        this.logger.logSelectQuery(collectionName, query);
        return (T)super.findOne(query, entityClass, collectionName);
    }

    public <T> List<T> find(Query query, Class<T> entityClass, String collectionName) {
        this.logger.logSelectQuery(collectionName, query);
        return super.find(query, entityClass, collectionName);
    }

    protected Object insertDBObject(String collectionName, DBObject dbDoc, Class<?> entityClass) {
        this.logger.logInsertQuery(collectionName, dbDoc, null);
        return super.insertDBObject(collectionName, dbDoc, entityClass);
    }

    protected List<ObjectId> insertDBObjectList(String collectionName, List<DBObject> dbDocList) {
        this.logger.logInsertQuery(collectionName, null, dbDocList);
        return super.insertDBObjectList(collectionName, dbDocList);
    }

    protected WriteResult doUpdate(String collectionName, Query query, Update update, Class<?> entityClass, boolean upsert, boolean multi) {
        this.logger.logUpdateQuery(collectionName, query, update, upsert, multi);
        return super.doUpdate(collectionName, query, update, entityClass, upsert, multi);
    }

    protected <T> WriteResult doRemove(String collectionName, Query query, Class<T> entityClass) {
        this.logger.logDeleteQuery(collectionName, query);
        return super.doRemove(collectionName, query, entityClass);
    }
}

