/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.service;

import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.service.IMessageDupHandle;
import com.efuture.omd.storage.FStorageOperations;
import java.util.HashMap;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MessageDupService
implements IMessageDupHandle {
    public static String StorageOperation = "StorageOperation_task";

    public FStorageOperations getStorageOperations() {
        return (FStorageOperations)SpringBeanFactory.getBean((String)StorageOperation, FStorageOperations.class);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public int checkMessageDup(Message msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", msg.getEnt_id());
        map.put("topic", msg.getTopic());
        map.put("keyvalue", msg.getKeyvalue());
        try {
            this.getStorageOperations().insert(map, "messagedup");
            return 1;
        }
        catch (Exception e) {
            if (e instanceof DuplicateKeyException) {
                return -1;
            }
            e.printStackTrace();
            return -2;
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public void delMessageDup(Message msg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ent_id", msg.getEnt_id());
        map.put("topic", msg.getTopic());
        map.put("keyvalue", msg.getKeyvalue());
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)msg.getEnt_id()).and("topic").is((Object)msg.getTopic()).and("keyvalue").is((Object)msg.getKeyvalue());
        Query query = new Query(criteria);
        try {
            this.getStorageOperations().delete(query, "messagedup");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

