/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.service;

import com.efuture.ocp.taskcore.consumer.ConsumerExecType;
import com.efuture.ocp.taskcore.consumer.ConsumerNode;
import com.efuture.ocp.taskcore.consumer.ConsumerReg;
import com.efuture.ocp.taskcore.consumer.IConsumerHandle;
import com.efuture.ocp.taskcore.consumer.IConsumerRegService;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.message.MessageConfig;
import com.efuture.ocp.taskcore.message.MessageStatus;
import com.efuture.ocp.taskcore.service.IMessageDupHandle;
import com.efuture.ocp.taskcore.service.TaskUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class TaskConsumer {
    private static Logger logger = Logger.getLogger(TaskConsumer.class);
    private ConsumerReg consumerreg;
    private ConsumerNode nodeconfig;
    private IConsumerRegService consumerRegService;
    private IConsumerHandle consumerHandler;
    private IMessageHandle messagehandle;
    private IMessageDupHandle messagedup;
    private boolean ib_init = false;
    private boolean canrun = true;
    private String topic;

    public boolean isCanrun() {
        return this.canrun;
    }

    public void setCanrun(boolean canrun) {
        this.canrun = canrun;
    }

    public IConsumerHandle getConsumerHandler() {
        return this.consumerHandler;
    }

    public IMessageHandle getMessagehandle() {
        return this.messagehandle;
    }

    public IMessageDupHandle getMessagedup() {
        return this.messagedup;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setConsumerHandler(IConsumerHandle consumerHandler) {
        this.consumerHandler = consumerHandler;
    }

    public void setMessagehandle(IMessageHandle messagehandle) {
        this.messagehandle = messagehandle;
    }

    public void setMessagedup(IMessageDupHandle messagedup) {
        this.messagedup = messagedup;
    }

    public IConsumerRegService getConsumerRegService() {
        return this.consumerRegService;
    }

    public void setConsumerRegService(IConsumerRegService consumerRegService) {
        this.consumerRegService = consumerRegService;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void init() {
        this.consumerreg = this.consumerRegService.reg(this.topic);
        if (this.consumerreg == null || StringUtils.isEmpty((Object)this.consumerreg.getConsumerkey())) {
            logger.error((Object)(this.topic + ">>>>>>>\u6ce8\u518c\u5931\u8d25"));
            return;
        }
        this.nodeconfig = new ConsumerNode();
        this.nodeconfig.setNodekey(this.consumerreg.getConsumerkey());
        this.nodeconfig.setNodestatus(this.consumerreg.getStatus());
        MessageConfig mc = TaskUtils.getMessageConfigbyTopic(this.topic);
        if (mc == null) {
            logger.error((Object)(this.topic + ">>>>>>>\u83b7\u53d6\u6d88\u606f\u914d\u7f6e\u5931\u8d25"));
            return;
        }
        this.nodeconfig.setMessageConfig(mc);
        this.ib_init = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumer() {
        if (!this.isCanrun()) {
            return;
        }
        if (!this.ib_init) {
            this.init();
            if (!this.ib_init) {
                logger.error((Object)(this.topic + ">>>>>>>\u6d88\u8d39\u8005\u521d\u59cb\u5316\u5931\u8d25,\u4e0d\u80fd\u6267\u884c!"));
                return;
            }
        }
        String execType = this.nodeconfig.getMessageConfig().getExectype();
        boolean c = true;
        do {
            List<Message> messageList;
            if ((messageList = this.getMessage()) != null && messageList.size() > 0) {
                for (Message msg : messageList) {
                    if (this.lockMessage(msg) < 1) continue;
                    int ret = this.messagedup.checkMessageDup(msg);
                    if (ret == -1) {
                        msg.setStatus(MessageStatus.DUP.name());
                        msg.setMsg("\u6d88\u606f\u91cd\u590d,\u4e0d\u6267\u884c");
                        this.consumeCallbackMessage(msg);
                        continue;
                    }
                    if (ret == -2) {
                        msg.setStatus(MessageStatus.FAIL.name());
                        msg.setMsg("\u5224\u91cd\u6d88\u606f\u5199\u5165\u5f02\u5e38");
                        this.consumeCallbackMessage(msg);
                        continue;
                    }
                    try {
                        this.doConsumer(msg);
                        msg.setStatus(MessageStatus.SUCCESS.name());
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
                        msg.setStatus(MessageStatus.FAIL.name());
                        String msgstr = e.getMessage();
                        if (!StringUtils.isEmpty((Object)msgstr)) {
                            if (msgstr.length() > 1900) {
                                msgstr = msgstr.substring(0, 1900);
                            }
                            msg.setMsg(msgstr);
                        } else {
                            msg.setMsg("Unknown Exception");
                        }
                        this.messagedup.delMessageDup(msg);
                    }
                    finally {
                        this.consumeCallbackMessage(msg);
                    }
                }
                if (!StringUtils.isEmpty((Object)execType) && execType.equals(ConsumerExecType.BATCH.name())) continue;
                c = false;
                break;
            }
            c = false;
            break;
        } while (c);
    }

    private void doConsumer(Message msg) throws Exception {
        this.consumerHandler.consume(this.nodeconfig, msg);
    }

    private List<Message> getMessage() {
        return this.messagehandle.pullNewMessage(this.nodeconfig);
    }

    private int lockMessage(Message msg) {
        return this.messagehandle.lockMessage(this.nodeconfig, msg);
    }

    public void consumeCallbackMessage(Message msg) {
        this.messagehandle.consumeCallbackMessage(this.nodeconfig, msg);
    }
}

