/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.service;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.transmanager.EventTransService;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

public class TaskProducer {
    private static Logger logger = Logger.getLogger(TaskProducer.class);
    private static String opentrans = "N";

    public static IMessageHandle getMessagehandle() {
        return (IMessageHandle)SpringBeanFactory.getBean((String)"MessageHandle", IMessageHandle.class);
    }

    public static void produce(long ent_id, String topic, String event, String keyvalue, String data, Date delayTime, int retryCount) {
        if (StringUtils.isEmpty((Object)topic) || topic.length() > 60) {
            throw new IllegalArgumentException("\u6d88\u606f\u6807\u9898\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((Object)keyvalue) || keyvalue.length() > 60) {
            throw new IllegalArgumentException("\u4e1a\u52a1\u4e3b\u952e\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((Object)event) || event.length() > 60) {
            throw new IllegalArgumentException("\u6765\u6e90\u4e8b\u4ef6\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        String jsonStr = null;
        if (data != null && (jsonStr = data).length() > 65535) {
            throw new IllegalArgumentException(">>>>>>>>>>> mq, message data length over limit 65535");
        }
        if (delayTime == null) {
            delayTime = new Date();
        }
        if (retryCount < 0) {
            retryCount = 0;
        }
        Message msg = new Message();
        msg.setEnt_id(ent_id);
        msg.setTopic(topic);
        msg.setEvent(event);
        msg.setKeyvalue(keyvalue);
        msg.setData(jsonStr);
        msg.setDelaydate(delayTime);
        msg.setRetryCount(retryCount);
        if ("N".equalsIgnoreCase(opentrans)) {
            TaskProducer.getMessagehandle().produce(msg);
        } else {
            EventTransService.addMsg(msg);
        }
    }

    @Async
    public static void asyncproduce(Message msg) {
        TaskProducer.getMessagehandle().produce(msg);
    }

    public static void produce(long ent_id, String topic, String event, String keyvalue, JSONObject data) {
        TaskProducer.produce(ent_id, topic, event, keyvalue, data.toJSONString(), new Date(), 0);
    }

    public static void produce(long ent_id, String topic, String event, String keyvalue, String data) {
        TaskProducer.produce(ent_id, topic, event, keyvalue, data, new Date(), 0);
    }

    public static void broadcast(long ent_id, String topic, String event, String keyvalue, JSONObject data) {
    }

    public static String getOpentrans() {
        return opentrans;
    }

    public static void setOpentrans(String opentrans) {
        TaskProducer.opentrans = opentrans;
    }
}

