/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.transmanager;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.service.TaskProducer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class EventTransService {
    @Autowired
    private static ApplicationContext applicationContext;
    protected static transient Log logger;
    private static final ThreadLocal<List<Message>> MESSAGELIST;
    private static final ThreadLocal<List<ApplicationEvent>> EVENTLIST;

    public static void addEvent(ApplicationEvent event) {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        if (eventlist == null) {
            eventlist = new ArrayList<ApplicationEvent>();
        }
        eventlist.add(event);
        EVENTLIST.set(eventlist);
    }

    public static void addMsg(Message msg) {
        List<Message> msglist = MESSAGELIST.get();
        if (msglist == null) {
            msglist = new ArrayList<Message>();
        }
        msglist.add(msg);
        MESSAGELIST.set(msglist);
    }

    private static void doMessageRollback() {
        List<Message> msglist = MESSAGELIST.get();
        if (msglist != null && msglist.size() > 0) {
            logger.info((Object)("doRollback--->\u6709\u6d88\u606f{" + msglist.size() + "}\u672a\u63d0\u4ea4!"));
            logger.info((Object)"************************************************************");
            logger.info(JSONObject.toJSON(msglist));
            logger.info((Object)"************************************************************");
        }
        MESSAGELIST.remove();
    }

    private static void doEventRollback() {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        if (eventlist != null && eventlist.size() > 0) {
            logger.info((Object)("doRollback:eventlist--->\u6709\u6d88\u606f{" + eventlist.size() + "}\u672a\u63d0\u4ea4!"));
            logger.info((Object)"************************************************************");
            logger.info(JSONObject.toJSON(eventlist));
            logger.info((Object)"************************************************************");
        }
        EVENTLIST.remove();
    }

    public static void doRollback() {
        EventTransService.doMessageRollback();
        EventTransService.doEventRollback();
    }

    private static void doMessageBegin() {
        List<Message> msglist = MESSAGELIST.get();
        if (msglist != null && msglist.size() > 0) {
            logger.info((Object)("doBegin--->\u6709\u6d88\u606f{" + msglist.size() + "}\u672a\u63d0\u4ea4!"));
            logger.info((Object)"************************************************************");
            logger.info(JSONObject.toJSON(msglist));
            logger.info((Object)"************************************************************");
        }
        MESSAGELIST.remove();
    }

    private static void doEventBegin() {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        if (eventlist != null && eventlist.size() > 0) {
            logger.info((Object)("doBegin:eventlist--->\u6709\u6d88\u606f{" + eventlist.size() + "}\u672a\u63d0\u4ea4!"));
            logger.info((Object)"************************************************************");
            logger.info(JSONObject.toJSON(eventlist));
            logger.info((Object)"************************************************************");
        }
        EVENTLIST.remove();
    }

    public static void doBegin() {
        EventTransService.doMessageBegin();
        EventTransService.doEventBegin();
    }

    private static void doMessageCommit() {
        List<Message> msglist = MESSAGELIST.get();
        try {
            if (msglist != null) {
                for (Message msg : msglist) {
                    TaskProducer.asyncproduce(msg);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u63d0\u4ea4\u6d88\u606f\u9519\u8bef!", (Throwable)e);
            logger.error((Object)"************************************************************");
            logger.error(JSONObject.toJSON(msglist));
            logger.error((Object)"************************************************************");
        }
        finally {
            MESSAGELIST.remove();
        }
    }

    private static void doEventCommit() {
        List<ApplicationEvent> eventlist = EVENTLIST.get();
        try {
            if (eventlist != null) {
                for (ApplicationEvent event : eventlist) {
                    SpringBeanFactory.getContext().publishEvent(event);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u63d0\u4ea4\u6d88\u606f\u9519\u8bef!", (Throwable)e);
            logger.error((Object)"************************************************************");
            logger.error(JSONObject.toJSON(eventlist));
            logger.error((Object)"************************************************************");
        }
        finally {
            EVENTLIST.remove();
        }
    }

    public static void doCommit() {
        EventTransService.doMessageCommit();
        EventTransService.doEventCommit();
    }

    static {
        logger = LogFactory.getLog(EventTransService.class);
        MESSAGELIST = new ThreadLocal();
        EVENTLIST = new ThreadLocal();
    }
}

