/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.service;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.service.IMessageDupHandle;
import com.efuture.omd.storage.FStorageOperations;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class MessageDupService
implements IMessageDupHandle {
    public static String StorageOperation = "StorageOperation_task";

    public FStorageOperations getStorageOperations() {
        return (FStorageOperations)SpringBeanFactory.getBean((String)StorageOperation, FStorageOperations.class);
    }

    @Override
    public int checkMessageDup(Message msg) {
        String keyvalue = msg.getKeyvalue();
        if (msg.getExecnode() != null && !msg.getExecnode().equals("")) {
            keyvalue = msg.getExecnode() + "-" + keyvalue;
        }
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)msg.getEnt_id()).and("topic").is((Object)msg.getTopic()).and("keyvalue").is((Object)keyvalue);
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("keyvalue");
        query.limit(1);
        Map rtn = this.getStorageOperations().selectOne(query, "messagedup");
        if (rtn == null) {
            return 1;
        }
        return -1;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public void onFail(Message msg) {
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, value="tasktransactionManager")
    public void onSuccess(Message msg) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ent_id", msg.getEnt_id());
            map.put("topic", msg.getTopic());
            map.put("instime", new Date());
            String keyvalue = msg.getKeyvalue();
            if (msg.getExecnode() != null && !msg.getExecnode().equals("")) {
                keyvalue = msg.getExecnode() + "-" + keyvalue;
            }
            map.put("keyvalue", keyvalue);
            this.getStorageOperations().insert(map, "messagedup");
        }
        catch (Exception ex) {
            throw new ServiceException("7001", ex.getMessage(), new Object[0]);
        }
    }
}

