/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.taskcore.service;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.message.MessageStatus;
import com.efuture.ocp.taskcore.transmanager.EventTransService;
import java.util.Date;
import org.apache.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

public class TaskProducer {
    private static Logger logger = Logger.getLogger(TaskProducer.class);
    private static String opentrans = "N";
    private static String messageHandleobj = "MessageHandle";

    public static String getMessageHandleobj() {
        return messageHandleobj;
    }

    public static void setMessageHandleobj(String messageHandleobj) {
        TaskProducer.messageHandleobj = messageHandleobj;
    }

    public static IMessageHandle getMessagehandle() {
        return (IMessageHandle)SpringBeanFactory.getBean((String)messageHandleobj, IMessageHandle.class);
    }

    public static int produce(long ent_id, String topic, String event, String keyvalue, String data, Date delayTime, int retryCount, boolean isRetry) {
        if (StringUtils.isEmpty((Object)topic) || topic.length() > 60) {
            throw new IllegalArgumentException("\u6d88\u606f\u6807\u9898\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((Object)keyvalue) || keyvalue.length() > 120) {
            throw new IllegalArgumentException("\u4e1a\u52a1\u4e3b\u952e\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isEmpty((Object)event) || event.length() > 60) {
            throw new IllegalArgumentException("\u6765\u6e90\u4e8b\u4ef6\u957f\u5ea6\u4e0d\u5408\u6cd5");
        }
        String jsonStr = null;
        if (data != null) {
            jsonStr = data;
        }
        if (delayTime == null) {
            delayTime = new Date();
        }
        if (retryCount < 0) {
            retryCount = 0;
        }
        Message msg = new Message();
        msg.setEnt_id(ent_id);
        msg.setTopic(topic);
        msg.setEvent(event);
        msg.setKeyvalue(keyvalue);
        msg.setData(jsonStr);
        msg.setDelaydate(delayTime);
        msg.setRetryCount(retryCount);
        if (isRetry) {
            msg.setStatus(MessageStatus.RETRY.name());
        }
        if ("N".equalsIgnoreCase(opentrans)) {
            return TaskProducer.getMessagehandle().produce(msg);
        }
        EventTransService.addMsg(msg);
        return 0;
    }

    @Async
    public static void asyncproduce(Message msg) {
        TaskProducer.getMessagehandle().produce(msg);
    }

    public static int produce(long ent_id, String topic, String event, String keyvalue, JSONObject data) {
        return TaskProducer.produce(ent_id, topic, event, keyvalue, data.toJSONString(), new Date(), 0, false);
    }

    public static int reProduce(long ent_id, String topic, String event, String keyvalue, String data) {
        return TaskProducer.produce(ent_id, topic, event, keyvalue, data, new Date(), 0, true);
    }

    public static int produce(long ent_id, String topic, String event, String keyvalue, String data) {
        return TaskProducer.produce(ent_id, topic, event, keyvalue, data, new Date(), 0, false);
    }

    public static void broadcast(long ent_id, String topic, String event, String keyvalue, JSONObject data) {
    }

    public static String getOpentrans() {
        return opentrans;
    }

    public static void setOpentrans(String opentrans) {
        TaskProducer.opentrans = opentrans;
    }
}

