package com.efuture.ocp.taskcore.autorollback;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.autorollback.RollBackOperationData;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.GlobParaEnt;
import com.efuture.ocp.common.util.RestClientUtils;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.common.util.Utils;
import com.efuture.ocp.taskcore.consumer.ConsumerNode;
import com.efuture.ocp.taskcore.consumer.IConsumerHandle;
import com.efuture.ocp.taskcore.message.Message;

/**
 * 标准AutoRollback消息消费处理组件
 * 
 * @author zhouwd
 *
 */
public class RestServiceAutoRollbackConsumer implements IConsumerHandle {

	public CustomAutoRollback getCustRollbackObj(RollBackOperationData data) {
		String CustomAutoRollbackObject = data.getUrlkey() + ".rollback";
		return SpringBeanFactory.getBean(CustomAutoRollbackObject, CustomAutoRollback.class);

	}

	public int consume(ConsumerNode nodeconfig, Message msg) throws Exception {
		RollBackOperationData data = new RollBackOperationData();
		JSONObject msgdata = (JSONObject) JSONObject.parse(msg.getMsg());
		if (msgdata.containsKey("urlkey") && msgdata.get("urlkey") != null) {
			data.setUrlkey(msgdata.get("urlkey").toString());
		}
		data.setEnt_id(msg.getEnt_id());
		
		ServiceSession session = new ServiceSession();
		session.setEnt_id(data.getEnt_id());
		
		data.setRollbackparam(msg.getMsg());
		data.setRollbackurl(data.getUrlkey().concat(".rollback"));
		CustomAutoRollback rollback = getCustRollbackObj(data);
		int rollbackrtn = 0;
		if (rollback != null) {
			rollbackrtn = rollback.doRollback(data);
		}
		if (rollbackrtn == CustomAutoRollback.rtncode.OK) {
			return rollbackrtn;
		} else if (rollbackrtn == CustomAutoRollback.rtncode.CONTINUE) {
			doRestRollback(data);
			return 0;
		} else {
			return rollbackrtn;
		}
	}

	// 根据企业得到处理对象，如果没有处理对象，则使用通用处理对象，
	private String getRestClient(long ent_id, String urlkey) {
		return GlobParaEnt.getvalue(ent_id, urlkey + ".restobj", "RestUtils");
	}

	public void doRestRollback(RollBackOperationData data) throws Exception {

		String restobj = getRestClient(data.getEnt_id(), data.getUrlkey());
		RestClientUtils restClient = RestClientUtils.getRestUtils(restobj);
		ServiceSession session = data.getSession();

		ServiceResponse rsp = restClient.sendRequest(session, data.getRollbackurl(), data.getRollbackparam(),data.getRollbackurl());
		if (!"0".equals(rsp.getReturncode())) {
			throw new ServiceException(rsp.getReturncode(), Utils.nvl(rsp.getData(), "未知错误类型!"));
		}
	}
}
