package com.efuture.ocp.taskcore.message;

import com.efuture.ocp.taskcore.consumer.ConsumerNode;

import java.util.List;

public interface IMessageHandle {

    interface msg_produce_rtncode {
		int SUCCESS = 0;
		int COMM_ERR = -1;
	}
	
	/**
	 * 产生一个消息
	 * @param msg
	 */
    int produce(Message msg);
	
	/**
	 * 获取新的消息
	 * @param node
	 * @param msg
	 * @return
	 */
    List<Message> pullNewMessage(ConsumerNode node);
	
	/**
	 * 锁定消息
	 * @param node
	 * @param msg
	 * @return
	 */
    default int lockMessage(ConsumerNode node, Message msg) {
        if (msg.tryLock()) {
            return 1;
        } else {
            return -1;
        }
    }

    /**
     * 解除消息锁定
     *
     * @param node
     * @param msg
     */
    default void unLockMessage(ConsumerNode node, Message msg) {
        msg.unLock();
    }
	/**
	 * 消费完回调处理
	 * @param node
     * @param msg
     */
    void consumeCallbackMessage(ConsumerNode node, Message msg);
}
