package com.efuture.ocp.taskcore.message;

import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.util.SpringBeanFactory;

import java.util.Date;

public class Message {
	
	private long ent_id;//企业ID
	private long id;//	number(20)	y		序号
	private String topic ;//	varchar2(20)	y	主题 表示处理方式
	private String event;//	varchar2(20)	y		来源事件 表示消息源
	private String keyvalue	;//varchar2(60)	y		消息主键值 -topic+'-'+value 用于判重
	private String data	;//varchar2(2000)	y		消息数据(json)格式
	private Date delaydate;//	date	y		执行时间-默认当前
	private int	retryCount;// 重试次数
	private Date createdate	;//date	y		创建时间
	private String status	;//varchar2(10)	y		消息状态 插入状态为n   y-数据已经被节点取走
	private Date execdate;//	date	y		处理时间
	private String execnode	;//varchar2(20)	y		处理节点
	private String msg;//错误描述
	
	public long getEnt_id() {
		return ent_id;
	}
	public long getId() {
		return id;
	}
	public String getTopic() {
		return topic;
	}
	public String getEvent() {
		return event;
	}
	public String getKeyvalue() {
		return keyvalue;
	}
	public String getData() {
		return data;
	}
	public Date getDelaydate() {
		return delaydate;
	}
	public Date getCreatedate() {
		return createdate;
	}
	public String getStatus() {
		return status;
	}
	public Date getExecdate() {
		return execdate;
	}
	public String getExecnode() {
		return execnode;
	}
	
	public String getMsg() {
		return msg;
	}
	public void setEnt_id(long ent_id) {
		this.ent_id = ent_id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public void setTopic(String topic) {
		this.topic = topic;
	}
	public void setEvent(String event) {
		this.event = event;
	}
	public void setKeyvalue(String keyvalue) {
		this.keyvalue = keyvalue;
	}
	public void setData(String data) {
		this.data = data;
	}
	public void setDelaydate(Date delaydate) {
		this.delaydate = delaydate;
	}
	public void setCreatedate(Date createdate) {
		this.createdate = createdate;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public void setExecdate(Date execdate) {
		this.execdate = execdate;
	}
	public void setExecnode(String execnode) {
		this.execnode = execnode;
	}
	
	public void setMsg(String msg) {
		this.msg = msg;
	}
	public int getRetryCount() {
		return retryCount;
	}
	public void setRetryCount(int retryCount) {
		this.retryCount = retryCount;
	}

    private DistributedLockHandle getLockHandle() {
        return SpringBeanFactory.getContext().getBean(DistributedLockHandle.class);
    }

    private String getLockKey() {
        return "msgLockkey:" + this.execnode + "-" + this.keyvalue;
    }

    public boolean tryLock(int lockExpire, int waitMillSeconds) {
        DistributedLockHandle lock = getLockHandle();
        if (lock == null) {
            return true;
        }
        return lock.tryLock(getLockKey(), lockExpire, waitMillSeconds);
    }

    public boolean tryLock() {
        return tryLock(120, 0);
    }

    public void unLock() {
        DistributedLockHandle lock = getLockHandle();
        if (lock == null) {
            return;
        }
        lock.unlock(getLockKey());
    }
}
