package com.efuture.ocp.taskcore.service;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.omd.storage.FStorageOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MessageDupService implements IMessageDupHandle {
    public static String StorageOperation = "StorageOperation_task";

	public FStorageOperations getStorageOperations() {
		return SpringBeanFactory.getBean(StorageOperation, FStorageOperations.class);
	}


    /*
     * (non-Javadoc)
     *
     * @see
     * com.efuture.ocp.taskcore.service.IMessageDupHandle#checkMessageDup(com.
     * efuture.ocp.taskcore.message.Message)
	 */


    public int checkMessageDup(Message msg) {
		String keyvalue = msg.getKeyvalue();
        if (msg.getExecnode() != null && !msg.getExecnode().equals("")) {
            keyvalue = msg.getExecnode() + "-" + keyvalue;
        }
        Criteria criteria = Criteria.where("ent_id").is(msg.getEnt_id()).and("topic").is(msg.getTopic()).and("keyvalue")
                .is(keyvalue);
        Query query = new Query(criteria);
        query.fields().include("keyvalue");
        query.limit(1);
        Map<String, Object> rtn = getStorageOperations().selectOne(query, "messagedup");
        if (rtn == null) {
			return 1;
        } else {
			return -1;
		}
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.efuture.ocp.taskcore.service.IMessageDupHandle#delMessageDup(com.
     * efuture.ocp.taskcore.message.Message)
	 */
    @Transactional(propagation = Propagation.REQUIRES_NEW, value = "tasktransactionManager")
    public void onFail(Message msg) {

    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, value = "tasktransactionManager")
    public void onSuccess(Message msg) {
        try {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("ent_id", msg.getEnt_id());
            map.put("topic", msg.getTopic());
            map.put("instime", new Date());
            String keyvalue = msg.getKeyvalue();
            if (msg.getExecnode() != null && !msg.getExecnode().equals("")) {
                keyvalue = msg.getExecnode() + "-" + keyvalue;
            }
            map.put("keyvalue", keyvalue);
            getStorageOperations().insert(map, "messagedup");
        } catch (Exception ex) {
            throw new ServiceException("7001", ex.getMessage());
        } finally {

		}

	}
}
