package com.efuture.ocp.taskcore.service;

import com.efuture.ocp.taskcore.consumer.*;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.message.MessageConfig;
import com.efuture.ocp.taskcore.message.MessageStatus;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 任务消费 1.每个任务一个实例 2.使用Spring task 配置 执行
 * 
 * @author zhouwudong
 *
 */
public class PullMessageTaskConsumer implements TaskConsumerService {
	private static Logger logger = Logger.getLogger(PullMessageTaskConsumer.class);

	private ConsumerReg consumerreg;

	private ConsumerNode nodeconfig;

	private IConsumerRegService consumerRegService;
	private IConsumerHandle consumerHandler;

	private IMessageHandle messagehandle;

	private IMessageDupHandle messagedup;

	private boolean ib_init = false;

	private boolean canrun = true;

	public PullMessageTaskConsumer(IConsumerRegService consumerRegService,
			IConsumerHandle consumerHandler, IMessageHandle messagehandle, IMessageDupHandle messagedup, boolean canrun,
			String topic) {
		super();
		this.consumerRegService = consumerRegService;
		this.consumerHandler = consumerHandler;
		this.messagehandle = messagehandle;
		this.messagedup = messagedup;
		this.canrun = canrun;
		this.topic = topic;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#isCanrun()
	 */
	public boolean isCanrun() {
		return canrun;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#setCanrun(boolean)
	 */
	public void setCanrun(boolean canrun) {
		this.canrun = canrun;
	}

	/**
	 * 消费主题
	 */
	private String topic;

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#getConsumerHandler()
	 */
	public IConsumerHandle getConsumerHandler() {
		return consumerHandler;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#getMessagehandle()
	 */
	public IMessageHandle getMessagehandle() {
		return messagehandle;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#getMessagedup()
	 */
	public IMessageDupHandle getMessagedup() {
		return messagedup;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#getTopic()
	 */
	public String getTopic() {
		return topic;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#setConsumerHandler(com.efuture.ocp.taskcore.consumer.IConsumerHandle)
	 */
	public void setConsumerHandler(IConsumerHandle consumerHandler) {
		this.consumerHandler = consumerHandler;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#setMessagehandle(com.efuture.ocp.taskcore.message.IMessageHandle)
	 */
	public void setMessagehandle(IMessageHandle messagehandle) {
		this.messagehandle = messagehandle;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#setMessagedup(com.efuture.ocp.taskcore.service.IMessageDupHandle)
	 */
	public void setMessagedup(IMessageDupHandle messagedup) {
		this.messagedup = messagedup;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#getConsumerRegService()
	 */
	public IConsumerRegService getConsumerRegService() {
		return consumerRegService;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#setConsumerRegService(com.efuture.ocp.taskcore.consumer.IConsumerRegService)
	 */
	public void setConsumerRegService(IConsumerRegService consumerRegService) {
		this.consumerRegService = consumerRegService;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#setTopic(java.lang.String)
	 */
	public void setTopic(String topic) {
		this.topic = topic;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#init()
	 */

	public void init() {
		consumerreg = consumerRegService.reg(topic);
		if (consumerreg == null || StringUtils.isEmpty(consumerreg.getConsumerkey())) {
			logger.error(topic + ">>>>>>>PullMessageTaskConsumer:注册失败");
			return;
		}
		nodeconfig = new ConsumerNode();
		nodeconfig.setNodekey(consumerreg.getConsumerkey());
		nodeconfig.setNodestatus(consumerreg.getStatus());
		MessageConfig mc = TaskUtils.getMessageConfigbyTopic(topic);
		if (mc == null) {
			logger.error(topic + ">>>>>>>PullMessageTaskConsumer:获取消息配置失败");
			return;
		}
		nodeconfig.setMessageConfig(mc);
		ib_init = true;
	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#consumer()
	 */
	public void consumer() {
		if (!this.isCanrun()) {
			return;
		}
		if (!ib_init) {
			init();
			if (!ib_init) {
				logger.error(topic + ">>>>>>>PullMessageTaskConsumer:消费者初始化失败,不能执行!");
				return;
			}
		}
		// execType = BATCH-批量执行(不按顺序，一次执行指定行消息，只到没有数据为止)
		// DEFAULT-默认(不按顺序，一次执行指定行数数据)
		String execType = nodeconfig.getMessageConfig().getExectype();

        // 得到要消费的列表
		boolean c = true;
		do {
			List<Message> messageList = getMessage();
			if (messageList != null && messageList.size() > 0) {
				for (Message msg : messageList) {
					// 锁定消息
					if (lockMessage(msg) < 1) {
						continue;
					}
					if (messagedup.checkMessageDup(msg) < 1) {
						// message is dup
						msg.setStatus(MessageStatus.DUP.name());
						msg.setMsg("消息重复,不执行");
						consumeCallbackMessage(msg);
						continue;
					}
					try {
						doConsumer(msg);
						// consume suceess
						msg.setStatus(MessageStatus.SUCCESS.name());
                        messagedup.onSuccess(msg);
					} catch (Exception e) {
						logger.error("", e);
						// consume error
						msg.setStatus(MessageStatus.FAIL.name());
						String msgstr = e.getMessage();
						if (!StringUtils.isEmpty(msgstr))
						{
    						if (msgstr.length() > 1900) {
    							msgstr = msgstr.substring(0, 1900);
    						}
    						msg.setMsg(msgstr);
						}
						else
						{
						    msg.setMsg("Unknown Exception");
						}
                        messagedup.onFail(msg);
					} finally {
						consumeCallbackMessage(msg);

						// logger.info(">>>>>>>>>>Task, consumer message: {}",
						// msg);
					}
				}

				if (StringUtils.isEmpty(execType) || !execType.equals(ConsumerExecType.BATCH.name())) {
					c = false;
					break;
				}

			} else {
				c = false;
				break;
			}
		} while (c);

	}

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#doConsumer(com.efuture.ocp.taskcore.message.Message)
	 */
	public void doConsumer(Message msg) throws Exception {
		consumerHandler.consume(nodeconfig, msg);
	}

	private List<Message> getMessage() {
		return messagehandle.pullNewMessage(nodeconfig);
	}

	private int lockMessage(Message msg) {
		return messagehandle.lockMessage(nodeconfig, msg);
	}

    private void unLockMessage(Message msg) {
        messagehandle.unLockMessage(nodeconfig, msg);
    }

	/* (non-Javadoc)
	 * @see com.efuture.ocp.taskcore.service.TaskConsumerService#consumeCallbackMessage(com.efuture.ocp.taskcore.message.Message)
	 */
	public void consumeCallbackMessage(Message msg) {
        try {
            messagehandle.consumeCallbackMessage(nodeconfig, msg);
        } catch (Exception e) {
            logger.error("[" + msg.getKeyvalue() + "]调用consumeCallbackMessage发生错误:", e);
        }
        unLockMessage(msg);
	}

}
