package com.efuture.ocp.taskcore.service;

import java.util.Date;

import org.apache.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.IMessageHandle;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.ocp.taskcore.message.MessageStatus;
import com.efuture.ocp.taskcore.transmanager.EventTransService;

public class TaskProducer {
	private static Logger logger = Logger.getLogger(TaskProducer.class);

	private static String opentrans = "N";
	private static String messageHandleobj = "MessageHandle";

	public static String getMessageHandleobj() {
		return messageHandleobj;
	}

	public static void setMessageHandleobj(String messageHandleobj) {
		TaskProducer.messageHandleobj = messageHandleobj;
	}

	public static IMessageHandle getMessagehandle() {
		return SpringBeanFactory.getBean(messageHandleobj, IMessageHandle.class);
	}

	public static int produce(long ent_id, String topic, String event, String keyvalue, String data, Date delayTime,
			int retryCount,boolean isRetry) {
		// name

		if (StringUtils.isEmpty(topic) || topic.length() > 60) {
			throw new IllegalArgumentException("消息标题长度不合法");
		}
		if (StringUtils.isEmpty(keyvalue) || keyvalue.length() > 120) {//第三方促销业务长度超过60
			throw new IllegalArgumentException("业务主键长度不合法");
		}
		if (StringUtils.isEmpty(event) || event.length() > 60) {
			throw new IllegalArgumentException("来源事件长度不合法");
		}
		// data
		String jsonStr = null;
		// 暂时去掉此判断，如果发MQ报错，且存不到数据库，直接记录日志
		if (data != null) {
			jsonStr = data;
//			if (jsonStr.length() > 2000) {
//
//				// throw new IllegalArgumentException(">>>>>>>>>>> mq, message
//				// data length over limit 2000");
//			}
		}
		// delayTime
		if (delayTime == null) {
			delayTime = new Date();
		}
		// retryCount
		if (retryCount < 0) {
			retryCount = 0;
		}

		Message msg = new Message();
		msg.setEnt_id(ent_id);
		msg.setTopic(topic);
		msg.setEvent(event);
		msg.setKeyvalue(keyvalue);
		msg.setData(jsonStr);
		msg.setDelaydate(delayTime);
		msg.setRetryCount(retryCount);
		if(isRetry){
			msg.setStatus(MessageStatus.RETRY.name());
		}
		if ("N".equalsIgnoreCase(opentrans)) {
			return getMessagehandle().produce(msg);
		} else {
			EventTransService.addMsg(msg);
			return 0;
		}

	}

	@Async
	public static void asyncproduce(Message msg) {
		getMessagehandle().produce(msg);
	}

	public static int produce(long ent_id, String topic, String event, String keyvalue, JSONObject data) {
		return produce(ent_id, topic, event, keyvalue, data.toJSONString(), new Date(), 0,false);
	}
	
	public static int reProduce(long ent_id, String topic, String event, String keyvalue, String data){
		return produce(ent_id, topic, event, keyvalue, data, new Date(), 0,true);
	}
	public static int produce(long ent_id, String topic, String event, String keyvalue, String data) {
		return produce(ent_id, topic, event, keyvalue, data, new Date(), 0,false);
	}

	/**
	 * 广播一个消息 未实现
	 * 
	 * @param name
	 * @param dataMap
	 */
	public static void broadcast(long ent_id, String topic, String event, String keyvalue, JSONObject data) {

	}

	public static String getOpentrans() {
		return opentrans;
	}

	public static void setOpentrans(String opentrans) {
		TaskProducer.opentrans = opentrans;
	}

}
