/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.MessageConvert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.MessageConvert.ConvertMessageToTask;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.param.TaskParam;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="convertMessageUtils")
public class ConvertMessageUtils
implements ApplicationContextAware,
InitializingBean {
    ApplicationContext applicationContext;
    ConcurrentHashMap<String, ConvertMessageToTask> convertRegistry = new ConcurrentHashMap();
    private DefaultConvertMessageHandle defaultConvertMessageHandle = new DefaultConvertMessageHandle();

    public ConvertMessageToTask getConvertMessageHandle(long entId, String topic) {
        if (StringUtils.isEmpty((Object)topic)) {
            topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(entId);
        }
        String defaultMsgConvertHandle = TaskParam.TASK_PUBLIC.TASK_DEFAULT_CONVERT_MESSAGE_HANDLE.getVal(entId);
        ConvertMessageToTask handle = this.convertRegistry.get(topic);
        if (handle == null) {
            handle = this.convertRegistry.get(defaultMsgConvertHandle);
        }
        if (handle == null) {
            return this.defaultConvertMessageHandle;
        }
        return handle;
    }

    public Task messageToTask(Message msg) {
        return this.getConvertMessageHandle(msg.getEnt_id(), msg.getTopic()).convertMessageToTask(msg);
    }

    public Task convertTask(Task task) {
        return this.getConvertMessageHandle(task.getEnt_id(), task.getTopic()).convertTask(task);
    }

    public void registerConvertMessageHandle(ConvertMessageToTask converter) {
        String topic = converter.regTopic();
        if (StringUtils.isEmpty((Object)topic)) {
            topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(0L);
        }
        String[] topics = topic.split(",");
        for (int i = 0; i < topics.length; ++i) {
            this.convertRegistry.put(topics[i], converter);
        }
    }

    public void afterPropertiesSet() {
        ServiceLogs.debuglog((String)"ConvertMessageUtils", (String)"\u5f00\u59cb\u6ce8\u518c\u6d88\u606f\u8f6c\u6362\u5668", (long)0L);
        Map convertMessageToTaskMap = this.applicationContext.getBeansOfType(ConvertMessageToTask.class);
        if (Objects.nonNull(convertMessageToTaskMap)) {
            for (ConvertMessageToTask converter : convertMessageToTaskMap.values()) {
                ServiceLogs.debuglog((String)"ConvertMessageUtils", (String)"\u6ce8\u518c\u6d88\u606f\u8f6c\u6362\u5668[{0}]", (long)0L, (Object[])new Object[]{converter.regTopic()});
                this.registerConvertMessageHandle(converter);
            }
        }
        ServiceLogs.debuglog((String)"ConvertMessageUtils", (String)"\u6ce8\u518c\u6d88\u606f\u8f6c\u6362\u5668\u5b8c\u6bd5,\u6ce8\u518c[{0}]\u4e2a", (long)0L, (Object[])new Object[]{convertMessageToTaskMap.size()});
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private class DefaultConvertMessageHandle
    implements ConvertMessageToTask {
        private DefaultConvertMessageHandle() {
        }

        public Task convertMessageToTask(Message msg) {
            JSONObject data = JSONObject.parseObject((String)msg.getData());
            Task task = (Task)JSONObject.toJavaObject((JSON)data, Task.class);
            task.setTopic(msg.getTopic());
            task.setExec_count(msg.getRetryCount());
            return task;
        }

        public Task convertTask(Task task) {
            return task;
        }

        public Class getTaskClass() {
            return Task.class;
        }

        @Override
        public String regTopic() {
            return "all";
        }
    }
}

