/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.entity;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.taskflow.entity.ExecReturn;
import com.efuture.taskflow.entity.InterTaskStatus;
import com.efuture.taskflow.entity.SubTaskStatusInfo;
import com.efuture.taskflow.param.TaskParam;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.data.annotation.Transient;
import org.springframework.util.StringUtils;

public class Task
extends AbstractEntityBean
implements Cloneable {
    private static final long serialVersionUID = -1929584351714980822L;
    @Transient
    InterTaskStatus taskStatus = new InterTaskStatus();
    private long ph_key;
    @NotNull(message="\u4efb\u52a1\u5355\u521b\u5efa\u65f6\u95f4")
    private Date ph_timestamp;
    @NotBlank(message="\u4efb\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private String billno;
    @NotBlank(message="\u6765\u6e90\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a")
    private String src_billno;
    private String others_billno;
    @NotBlank(message="\u4efb\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    private String task_type;
    private String task_group;
    private String parent_billno;
    @NotBlank(message="\u662f\u5426\u662f\u4e3b\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a")
    private String isMainTask = "N";
    private int tot_step;
    private int step;
    private int task_status = 0;
    private int tot_subtask_num = 0;
    private int success_subtask_num = 0;
    private int error_subtask_num = 0;
    private int exec_count = 0;
    private long Last_exec_date;
    private String last_exec_error;
    private String last_exec_errorCode;
    private String last_exec_errorGroup;
    @Transient
    private String src_table = "MQ";
    private String topic;
    @Transient
    private int run_mode = 0;
    @Transient
    private ExecReturn execReturn;
    @Transient
    private JSONObject data;

    public Task() {
    }

    public Task(long entId, String billno, String src_billno, String task_type, String task_group, int tot_step, int step, Object data) {
        this.ent_id = entId;
        this.billno = billno;
        this.src_billno = src_billno;
        this.task_type = task_type;
        this.task_group = task_group;
        this.tot_step = tot_step;
        this.step = step;
        this.data = (JSONObject)JSONObject.toJSON((Object)data);
        this.setPh_timestamp(new Date());
        this.setTopic(TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(entId));
    }

    public String toString() {
        return this.billno;
    }

    public InterTaskStatus getTaskStatus() {
        this.taskStatus.setTask_status(this.task_status);
        return this.taskStatus;
    }

    public void setTaskStatus(InterTaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Task newInstance() {
        return new Task();
    }

    public Task fastCopy(Task task, String newBillno, String task_type, int curStep, Object data) {
        Task subTask = task.newInstance();
        subTask.setEnt_id(task.getEnt_id());
        subTask.setBillno(newBillno);
        subTask.setParent_billno(task.getBillno());
        subTask.setPh_timestamp(new Date());
        subTask.setTask_status(0);
        subTask.setTask_group(task.getTask_group());
        subTask.setTask_type(task_type);
        subTask.setData(data);
        subTask.setSrc_billno(task.getSrc_billno());
        subTask.setOthers_billno(task.getOthers_billno());
        subTask.setTot_step(task.getTot_step());
        subTask.setStep(curStep);
        if (subTask.getTot_step() <= subTask.getStep()) {
            subTask.setIsMainTask("L");
        }
        return subTask;
    }

    public Task clone() {
        try {
            return (Task)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isNotStart() {
        return this.getTask_status() < 20;
    }

    public boolean isExecComplete() {
        return this.getTask_status() >= 29;
    }

    public boolean isExecing() {
        return this.getTask_status() < 99;
    }

    public boolean isThisComplete() {
        return this.getTask_status() >= 99;
    }

    public boolean isWaitSubComplete() {
        return this.getTask_status() == 99;
    }

    public boolean isCreateSubComplete() {
        return this.getTask_status() >= 59;
    }

    public boolean isStoped() {
        return this.getTask_status() >= 200;
    }

    public boolean hasParent() {
        return !StringUtils.isEmpty((Object)this.parent_billno);
    }

    public boolean isAllSubCompleted() {
        if (this.tot_subtask_num <= this.success_subtask_num + this.error_subtask_num) {
            this.setTask_status(200);
            return true;
        }
        return false;
    }

    public boolean hasSub() {
        return this.tot_subtask_num > 0;
    }

    public String getLockKey() {
        return "lock:" + this.getBillno();
    }

    public String getStatusKey() {
        return "status:" + this.getBillno();
    }

    public String getParentStatusKey() {
        return "status:" + this.getParent_billno();
    }

    public String getStatusValue() {
        return JSONObject.toJSONString((Object)this.getTaskStatus());
    }

    public InterTaskStatus convertToTaskStatus(String statusValue) {
        return (InterTaskStatus)JSONObject.parseObject((String)statusValue, InterTaskStatus.class);
    }

    public boolean setStatusValue(String statusValue) {
        if (statusValue == null) {
            throw new ServiceException("600001", "\u72b6\u6001\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        InterTaskStatus newstatus = this.convertToTaskStatus(statusValue);
        int oldstatus = this.getTask_status();
        int newStatus = newstatus.getTask_status();
        boolean ibChanged = false;
        if (newStatus > oldstatus) {
            this.setTask_status(newStatus);
            ibChanged = true;
        }
        return ibChanged;
    }

    public String getDataKey() {
        return "data:" + this.getBillno();
    }

    public String getParent_billno() {
        return this.parent_billno;
    }

    public void setParent_billno(String parent_billno) {
        this.parent_billno = parent_billno;
    }

    public ExecReturn getExecReturn() {
        return this.execReturn;
    }

    public void setExecReturn(ExecReturn execReturn) {
        this.execReturn = execReturn;
    }

    public JSONObject getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data instanceof String ? (JSONObject)JSONObject.parse((String)((String)data)) : (JSONObject)JSONObject.toJSON((Object)data);
    }

    public long getPh_key() {
        return this.ph_key;
    }

    public void setPh_key(long ph_key) {
        this.ph_key = ph_key;
    }

    public Date getPh_timestamp() {
        if (this.ph_timestamp == null) {
            this.ph_timestamp = new Date();
        }
        return this.ph_timestamp;
    }

    public void setPh_timestamp(Date ph_timestamp) {
        this.ph_timestamp = ph_timestamp;
    }

    public String getBillno() {
        return this.billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public String getOthers_billno() {
        return this.others_billno;
    }

    public void setOthers_billno(String channel_billno) {
        this.others_billno = channel_billno;
    }

    public String getTask_type() {
        return this.task_type;
    }

    public void setTask_type(String task_type) {
        this.task_type = task_type;
    }

    public int getTot_subtask_num() {
        return this.tot_subtask_num;
    }

    public void setTot_subtask_num(int tot_subtask_num) {
        this.tot_subtask_num = tot_subtask_num;
    }

    public int getError_subtask_num() {
        return this.error_subtask_num;
    }

    public void setError_subtask_num(int error_subtask_num) {
        this.error_subtask_num = error_subtask_num;
    }

    public int getTask_status() {
        return this.task_status;
    }

    public void setTask_status(int task_status) {
        this.task_status = task_status;
    }

    public String getIsMainTask() {
        return this.isMainTask;
    }

    public void setIsMainTask(String isMainTask) {
        this.isMainTask = isMainTask;
    }

    public String getSrc_billno() {
        return this.src_billno;
    }

    public void setSrc_billno(String src_billno) {
        this.src_billno = src_billno;
    }

    public int getSuccess_subtask_num() {
        return this.success_subtask_num;
    }

    public void setSuccess_subtask_num(int success_subtask_num) {
        this.success_subtask_num = success_subtask_num;
    }

    public int getTot_step() {
        return this.tot_step;
    }

    public void setTot_step(int tot_step) {
        this.tot_step = tot_step;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getTask_group() {
        return this.task_group;
    }

    public void setTask_group(String task_group) {
        this.task_group = task_group;
    }

    public int getExec_count() {
        return this.exec_count;
    }

    public void setExec_count(int exec_count) {
        this.exec_count = exec_count;
    }

    public String getLast_exec_error() {
        return this.last_exec_error;
    }

    public void setLast_exec_error(String last_exec_error) {
        this.last_exec_error = last_exec_error;
    }

    public long getLast_exec_date() {
        return this.Last_exec_date;
    }

    public void setLast_exec_date(Date lastDate) {
        this.Last_exec_date = lastDate.getTime() / 1000L;
    }

    public void setLast_exec_date(long lastDate) {
        this.Last_exec_date = lastDate;
    }

    public void setSubTaskStatusInfo(SubTaskStatusInfo subTaskInfo) {
        this.success_subtask_num = subTaskInfo.getSuccess_subtask_num();
        this.error_subtask_num = subTaskInfo.getError_subtask_num();
    }

    public String getSrc_table() {
        return this.src_table;
    }

    public void setSrc_table(String src_table) {
        this.src_table = src_table;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getRun_mode() {
        return this.run_mode;
    }

    public void setRun_mode(int run_mode) {
        this.run_mode = run_mode;
    }

    public String getLast_exec_errorCode() {
        return this.last_exec_errorCode;
    }

    public void setLast_exec_errorCode(String last_exec_errorCode) {
        this.last_exec_errorCode = last_exec_errorCode;
    }

    public void setLast_exec_errorCode(String errorGroup, String errorCode) {
        this.last_exec_errorGroup = errorGroup;
        this.last_exec_errorCode = errorCode;
    }

    public String getLast_exec_errorGroup() {
        return this.last_exec_errorGroup;
    }

    public void setLast_exec_errorGroup(String last_exec_errorGroup) {
        this.last_exec_errorGroup = last_exec_errorGroup;
    }
}

