/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.job;

import com.efuture.ocp.common.distributedLock.exception.DistributedLockException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.ocp.common.util.DateUtils;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.exception.TaskExceptionCode;
import com.efuture.taskflow.monitoring.UnfinishedTaskSummary;
import com.efuture.taskflow.taskmanager.TaskStatusManager;
import java.util.Date;
import java.util.List;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component(value="taskJob")
public class TaskJob {
    String logtype = "TaskJob";

    @Scheduled(initialDelay=600000L, fixedDelay=600000L)
    public void checkTaskStatus() {
        UnfinishedTaskSummary taskSummary = new UnfinishedTaskSummary();
        ServiceLogs.setCurLogKey((String)(this.logtype + "-" + new Date().getTime()));
        try {
            this.checkTaskStatus(1, taskSummary);
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)this.logtype, (Exception)e, (String)"\u5237\u65b0[\u7b49\u5f85\u4efb\u52a1]\u7684\u72b6\u6001\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        try {
            this.checkTaskStatus(0, taskSummary);
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)this.logtype, (Exception)e, (String)"\u5237\u65b0[\u672a\u5b8c\u6210\u4efb\u52a1]\u7684\u72b6\u6001\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        taskSummary.save();
    }

    public checkRtn checkTaskStatus(long entId, String billno) {
        Task task = TaskComponentFactory.getTaskRepository().findTaskByBillno(entId, billno);
        return this.checkTaskStatus(TaskComponentFactory.getTaskStatusManager(), task, true);
    }

    public checkRtn checkTaskStatus(TaskStatusManager tsm, Task task, boolean ibForce) {
        if (!ibForce && this.hasChecked(task)) {
            ServiceLogs.debuglog((String)this.logtype, (String)"\u4efb\u52a1[{0}]\u5df2\u7ecf\u5728\u672c\u65f6\u6bb5\u5237\u65b0\u8fc7,\u7b49\u4e0b\u4e00\u65f6\u6bb5\u518d\u5237\u65b0", (long)0L, (Object[])new Object[]{task.getBillno()});
            return new checkRtn(99, "\u5df2\u7ecf\u5728\u672c\u65f6\u6bb5\u5237\u65b0\u8fc7,\u7b49\u4e0b\u4e00\u65f6\u6bb5\u518d\u5237\u65b0");
        }
        ServiceLogs.debuglog((String)this.logtype, (String)"\u5237\u65b0\u4efb\u52a1[{0}]\u7684\u72b6\u6001", (long)0L, (Object[])new Object[]{task.getBillno()});
        try {
            tsm.refreshTaskStatus(task);
            return new checkRtn(0, "\u5237\u65b0\u6210\u529f");
        }
        catch (DistributedLockException e) {
            ServiceLogs.errLog((String)this.logtype, (Exception)((Object)e), (String)"\u5237\u65b0\u4efb\u52a1[{0}]\u7684\u72b6\u6001\u5931\u8d25,\u83b7\u53d6\u9501\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a[{1}]", (Object[])new Object[]{task.getBillno(), e.getMessage()});
            return new checkRtn(-1, "\u5237\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25,\u83b7\u53d6\u9501\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)this.logtype, (Exception)e, (String)"\u5237\u65b0\u4efb\u52a1[{0}]\u7684\u72b6\u6001\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a[{1}]", (Object[])new Object[]{task.getBillno(), e.getMessage()});
            tsm.refreshTaskError(task, "\u5237\u65b0\u4efb\u52a1\u72b6\u6001:" + e.getMessage());
            return new checkRtn(-1, "\u5237\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u4e3a:" + e.getMessage());
        }
    }

    private void checkTaskStatus(int checktype, UnfinishedTaskSummary taskSummary) {
        List<Task> taskList;
        TaskStatusManager tsm = TaskComponentFactory.getTaskStatusManager();
        int i = 0;
        long start = System.currentTimeMillis();
        ServiceLogs.debuglog((String)this.logtype, (String)"\u5f00\u59cb\u68c0\u67e5\u4efb\u52a1\u72b6\u6001-[{0}]", (long)0L, (Object[])new Object[]{checktype});
        Date lastDate = null;
        long lastPhkey = 0L;
        Date endDate = DateUtils.addMinutes((Date)new Date(), (int)-10);
        while ((taskList = this.getNeedCheckTaskList(checktype, lastDate, endDate, lastPhkey)) != null && taskList.size() >= 1) {
            i += taskList.size();
            for (Task task : taskList) {
                lastDate = task.getPh_timestamp();
                lastPhkey = task.getPh_key();
                checkRtn rtn = this.checkTaskStatus(tsm, task, false);
                taskSummary.possessTask(task);
                if (rtn.getCode() == 99) continue;
                this.setLastCheckTime(task);
            }
            if (i < 100000) continue;
        }
        ServiceLogs.debuglog((String)this.logtype, (String)"\u68c0\u67e5\u4efb\u52a1\u72b6\u6001\u5b8c\u6210,\u5237\u65b0[{1}]\u7c7b\u4efb\u52a1[{0}]\u6761", (long)start, (Object[])new Object[]{i, checktype});
    }

    private String getCheckKey(Task task) {
        return "check:" + task.getLockKey();
    }

    private long getLastCheckTime(Task task) {
        String key = this.getCheckKey(task);
        Object obj = CacheUtils.getCacheUtils().getData(key);
        if (obj != null) {
            return (Long)obj;
        }
        return 0L;
    }

    private void setLastCheckTime(Task task) {
        String key = this.getCheckKey(task);
        long time = System.currentTimeMillis();
        CacheUtils.getCacheUtils().putData(key, (Object)time, 600);
    }

    private boolean hasChecked(Task task) {
        long lastCheckTime;
        long time = System.currentTimeMillis();
        return time - (lastCheckTime = this.getLastCheckTime(task)) < 600000L;
    }

    private List<Task> getNeedCheckTaskList(int checktype, Date startDate, Date endDate, long lastPhkey) {
        if (checktype == 0) {
            return TaskComponentFactory.getTaskRepository().queryUnfinishedTaskInfo(startDate, endDate, lastPhkey);
        }
        if (checktype == 1) {
            return TaskComponentFactory.getTaskRepository().queryWaitSubTaskInfo(startDate, endDate, lastPhkey);
        }
        TaskExceptionCode.WRONG_CHECK_TYPE.throwThisException(checktype);
        return null;
    }

    public class checkRtn {
        int code;
        String msg;

        public checkRtn(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }

    private static interface CHECKTYPE {
        public static final int unfinish = 0;
        public static final int waitSub = 1;
    }
}

