/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.monitoring;

import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.repository.TaskRepository;
import java.util.Date;
import java.util.Map;

public class FinishedTaskSummary {
    Date startDate;
    Date endDate;
    long succeed;
    long failed;
    Map<String, Long> failReasons;

    public FinishedTaskSummary(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public static FinishedTaskSummary getTaskSummary(Date startDay, Date endDay) {
        FinishedTaskSummary rtn = new FinishedTaskSummary(startDay, endDay);
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        rtn.failReasons = repository.queryFailedTaskErrorGroup(startDay, endDay);
        for (Long c : rtn.failReasons.values()) {
            rtn.failed += c.longValue();
        }
        rtn.succeed = repository.querySucceedTaskCount(startDay, endDay);
        return rtn;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public long getSucceed() {
        return this.succeed;
    }

    public void setSucceed(long succeed) {
        this.succeed = succeed;
    }

    public long getFailed() {
        return this.failed;
    }

    public void setFailed(long failed) {
        this.failed = failed;
    }

    public Map<String, Long> getFailReasons() {
        return this.failReasons;
    }

    public void setFailReasons(Map<String, Long> failReasons) {
        this.failReasons = failReasons;
    }
}

