/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.monitoring;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.taskflow.entity.Task;
import java.util.Date;

public class UnfinishedTaskSummary {
    Date summaryDate = new Date();
    int runingNum;
    int retryingNum;
    int waitingNum;

    public static UnfinishedTaskSummary getTaskSummary() {
        String str = CacheUtils.getCacheUtils().getData(UnfinishedTaskSummary.getCacheKey()).toString();
        UnfinishedTaskSummary summary = (UnfinishedTaskSummary)JSONObject.parseObject((String)str, UnfinishedTaskSummary.class);
        return summary;
    }

    public static String getCacheKey() {
        return "$TASK_SUMMARY_CACHE$";
    }

    public void possessTask(Task task) {
        if (task.getTask_status() == 99) {
            ++this.waitingNum;
        } else if (task.getTask_status() < 99) {
            if (task.getExec_count() >= 1) {
                ++this.retryingNum;
            } else {
                ++this.runingNum;
            }
        } else if (task.getTask_status() > 99) {
            // empty if block
        }
    }

    public void save() {
        this.setValToCached(UnfinishedTaskSummary.getCacheKey(), JSONObject.toJSONString((Object)this), 30);
    }

    private void setValToCached(String key, String val, int mins) {
        CacheUtils.getCacheUtils().putData(key, (Object)val, mins * 60);
    }

    public Date getSummaryDate() {
        return this.summaryDate;
    }

    public void setSummaryDate(Date summaryDate) {
        this.summaryDate = summaryDate;
    }

    public int getRuningNum() {
        return this.runingNum;
    }

    public void setRuningNum(int runingNum) {
        this.runingNum = runingNum;
    }

    public int getRetryingNum() {
        return this.retryingNum;
    }

    public void setRetryingNum(int retryingNum) {
        this.retryingNum = retryingNum;
    }

    public int getWaitingNum() {
        return this.waitingNum;
    }

    public void setWaitingNum(int waitingNum) {
        this.waitingNum = waitingNum;
    }
}

