/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.param;

import java.util.ArrayList;
import java.util.List;

public class ConsoleTable {
    private List<List> rows = new ArrayList<List>();
    private int colum;
    private int[] columLen;
    private static int margin = 2;
    private boolean printHeader = false;

    public ConsoleTable(int colum, boolean printHeader) {
        this.printHeader = printHeader;
        this.colum = colum;
        this.columLen = new int[colum];
    }

    public void appendRow() {
        ArrayList row = new ArrayList(this.colum);
        this.rows.add(row);
    }

    public ConsoleTable appendColum(Object value) {
        if (value == null) {
            value = "NULL";
        }
        List row = this.rows.get(this.rows.size() - 1);
        row.add(value);
        int len = value.toString().getBytes().length;
        if (this.columLen[row.size() - 1] < len) {
            this.columLen[row.size() - 1] = len;
        }
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int sumlen = 0;
        for (int len : this.columLen) {
            sumlen += len;
        }
        if (this.printHeader) {
            buf.append("|").append(this.printChar('=', sumlen + margin * 2 * this.colum + (this.colum - 1))).append("|\n");
        } else {
            buf.append("|").append(this.printChar('-', sumlen + margin * 2 * this.colum + (this.colum - 1))).append("|\n");
        }
        for (int ii = 0; ii < this.rows.size(); ++ii) {
            List row = this.rows.get(ii);
            for (int i = 0; i < this.colum; ++i) {
                String o = "";
                if (i < row.size()) {
                    o = row.get(i).toString();
                }
                buf.append('|').append(this.printChar(' ', margin)).append(o);
                buf.append(this.printChar(' ', this.columLen[i] - o.getBytes().length + margin));
            }
            buf.append("|\n");
            if (this.printHeader && ii == 0) {
                buf.append("|").append(this.printChar('=', sumlen + margin * 2 * this.colum + (this.colum - 1))).append("|\n");
                continue;
            }
            buf.append("|").append(this.printChar('-', sumlen + margin * 2 * this.colum + (this.colum - 1))).append("|\n");
        }
        return buf.toString();
    }

    private String printChar(char c, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }
}

