/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.param;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Pattern;

public class TableList {
    private static final String[] BLINE = new String[]{"-", "\u2501"};
    private static final String[] CROSSING = new String[]{"-+-", "\u2548"};
    private static final String[] VERTICAL_TSEP = new String[]{"|", "\u2502"};
    private static final String[] VERTICAL_BSEP = new String[]{"|", "\u2503"};
    private static final String TLINE = "\u2500";
    private static final String CORNER_TL = "\u250c";
    private static final String CORNER_TR = "\u2510";
    private static final String CORNER_BL = "\u2517";
    private static final String CORNER_BR = "\u251b";
    private static final String CROSSING_L = "\u2522";
    private static final String CROSSING_R = "\u252a";
    private static final String CROSSING_T = "\u252c";
    private static final String CROSSING_B = "\u253b";
    private String[] descriptions;
    private ArrayList<String[]> table;
    private int[] tableSizes;
    private int rows;
    private int findex;
    private String filter;
    private boolean ucode;
    private Comparator<String[]> comparator;
    private int spacing;
    private EnumAlignment[] aligns;

    public TableList(String ... descriptions) {
        this(descriptions.length, descriptions);
    }

    public TableList(int columns, String ... descriptions) {
        if (descriptions.length != columns) {
            throw new IllegalArgumentException();
        }
        this.filter = null;
        this.rows = columns;
        this.descriptions = descriptions;
        this.table = new ArrayList();
        this.tableSizes = new int[columns];
        this.updateSizes(descriptions);
        this.ucode = false;
        this.spacing = 1;
        this.aligns = new EnumAlignment[columns];
        this.comparator = null;
        for (int i = 0; i < this.aligns.length; ++i) {
            this.aligns[i] = EnumAlignment.LEFT;
        }
    }

    private void updateSizes(String[] elements) {
        for (int i = 0; i < this.tableSizes.length; ++i) {
            if (elements[i] == null) continue;
            int j = this.tableSizes[i];
            this.tableSizes[i] = j = Math.max(j, elements[i].length());
        }
    }

    public TableList compareWith(Comparator<String[]> c) {
        this.comparator = c;
        return this;
    }

    public TableList sortBy(int column) {
        return this.compareWith((o1, o2) -> o1[column].compareTo(o2[column]));
    }

    public TableList align(int column, EnumAlignment align) {
        this.aligns[column] = align;
        return this;
    }

    public TableList withSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public TableList addRow(String ... elements) {
        if (elements.length != this.rows) {
            throw new IllegalArgumentException();
        }
        this.table.add(elements);
        this.updateSizes(elements);
        return this;
    }

    public TableList filterBy(int par0, String pattern) {
        this.findex = par0;
        this.filter = pattern;
        return this;
    }

    public TableList withUnicode(boolean ucodeEnabled) {
        this.ucode = ucodeEnabled;
        return this;
    }

    public void print() {
        int i;
        StringBuilder line = null;
        if (this.ucode) {
            for (i = 0; i < this.rows; ++i) {
                if (line != null) {
                    line.append(CROSSING_T);
                } else {
                    line = new StringBuilder();
                    line.append(CORNER_TL);
                }
                for (int j = 0; j < this.tableSizes[i] + 2 * this.spacing; ++j) {
                    line.append(TLINE);
                }
            }
            line.append(CORNER_TR);
            System.out.println(line.toString());
            line = null;
        }
        for (i = 0; i < this.rows; ++i) {
            if (line != null) {
                line.append(this.gc(VERTICAL_TSEP));
            } else {
                line = new StringBuilder();
                if (this.ucode) {
                    line.append(this.gc(VERTICAL_TSEP));
                }
            }
            String part = this.descriptions[i];
            while (part.length() < this.tableSizes[i] + this.spacing) {
                part = part + " ";
            }
            for (int j = 0; j < this.spacing; ++j) {
                line.append(" ");
            }
            line.append(part);
        }
        if (this.ucode) {
            line.append(this.gc(VERTICAL_TSEP));
        }
        System.out.println(line.toString());
        line = null;
        for (i = 0; i < this.rows; ++i) {
            if (line != null) {
                line.append(this.gc(CROSSING));
            } else {
                line = new StringBuilder();
                if (this.ucode) {
                    line.append(CROSSING_L);
                }
            }
            for (int j = 0; j < this.tableSizes[i] + 2 * this.spacing; ++j) {
                line.append(this.gc(BLINE));
            }
        }
        if (this.ucode) {
            line.append(CROSSING_R);
        }
        System.out.println(line.toString());
        line = null;
        ArrayList<String[]> localTable = this.table;
        if (this.filter != null) {
            Pattern p = Pattern.compile(this.filter);
            localTable.removeIf(arr -> {
                String s = arr[this.findex];
                return !p.matcher(s).matches();
            });
        }
        if (localTable.isEmpty()) {
            String[] sa = new String[this.rows];
            localTable.add(sa);
        }
        localTable.forEach(arr -> {
            for (int i = 0; i < ((String[])arr).length; ++i) {
                if (arr[i] != null) continue;
                arr[i] = "";
            }
        });
        if (this.comparator != null) {
            localTable.sort(this.comparator);
        }
        for (String[] strings : localTable) {
            for (int i2 = 0; i2 < this.rows; ++i2) {
                int j;
                if (line != null) {
                    line.append(this.gc(VERTICAL_BSEP));
                } else {
                    line = new StringBuilder();
                    if (this.ucode) {
                        line.append(this.gc(VERTICAL_BSEP));
                    }
                }
                String part = "";
                for (j = 0; j < this.spacing; ++j) {
                    part = part + " ";
                }
                if (strings[i2] != null) {
                    switch (this.aligns[i2]) {
                        case LEFT: {
                            part = part + strings[i2];
                            break;
                        }
                        case RIGHT: {
                            for (j = 0; j < this.tableSizes[i2] - strings[i2].length(); ++j) {
                                part = part + " ";
                            }
                            part = part + strings[i2];
                            break;
                        }
                        case CENTER: {
                            for (j = 0; j < (this.tableSizes[i2] - strings[i2].length()) / 2; ++j) {
                                part = part + " ";
                            }
                            part = part + strings[i2];
                        }
                    }
                }
                while (part.length() < this.tableSizes[i2] + this.spacing) {
                    part = part + " ";
                }
                for (j = 0; j < this.spacing; ++j) {
                    part = part + " ";
                }
                line.append(part);
            }
            if (this.ucode) {
                line.append(this.gc(VERTICAL_BSEP));
            }
            System.out.println(line.toString());
            line = null;
        }
        if (this.ucode) {
            for (int i3 = 0; i3 < this.rows; ++i3) {
                if (line != null) {
                    line.append(CROSSING_B);
                } else {
                    line = new StringBuilder();
                    line.append(CORNER_BL);
                }
                for (int j = 0; j < this.tableSizes[i3] + 2 * this.spacing; ++j) {
                    line.append(this.gc(BLINE));
                }
            }
            line.append(CORNER_BR);
            System.out.println(line.toString());
        }
    }

    private String gc(String[] src) {
        return src[this.ucode ? 1 : 0];
    }

    public static enum EnumAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

