/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.repository;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.BatchInsService;
import com.efuture.ocp.common.util.MapUtils;
import com.efuture.ocp.common.util.StorageUtils;
import com.efuture.ocp.common.util.UniqueID;
import com.efuture.omd.storage.FMybatisTemplate;
import com.efuture.omd.storage.FStorageOperations;
import com.efuture.taskflow.entity.SubTaskStatusInfo;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.entity.TaskErrorInfo;
import com.efuture.taskflow.entity.TaskExecCompleteLog;
import com.efuture.taskflow.exception.TaskExceptionCode;
import com.efuture.taskflow.repository.TaskRepository;
import com.efuture.taskflow.utils.DataBaseConfigUtils;
import com.efuture.taskflow.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Transient;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="taskRepositoryBydb")
public class TaskRepositoryDbImpl
implements TaskRepository {
    @Autowired
    BatchInsService batchIns;
    List<String> ALL_TASK_TABLE = null;
    List<String> notCompletedTaskTables = null;

    private String getTableName(String OriTableName) {
        return DataBaseConfigUtils.getTableName(OriTableName);
    }

    @Override
    @Transactional
    public Task save(Task task) {
        if (task.getPh_key() != 0L) {
            ServiceLogs.debuglog((String)"Task-SAVE", (String)"ph_key\u4e0d\u4e3a0,\u4e0d\u4fdd\u5b58\u6570\u636e\u5e93", (long)0L);
            return task;
        }
        task.setPh_key(UniqueID.getUniqueID());
        task.setTask_status(10);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        Task extTask = this.checkTaskExist(task);
        if (extTask == null) {
            fso.insert((Object)task, this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
        } else {
            extTask.setData(task.getData());
            task = extTask;
        }
        return task;
    }

    private Map<String, Object> taskToColMap(Object task) {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        AbstractEntityBean.fetchAllDeclaredField(task.getClass(), (StringBuffer)sb);
        String[] flds = sb.toString().split(",");
        HashSet beanFields = new HashSet();
        for (String col : flds) {
            Field fld = AbstractEntityBean.fetchDeclaredField(Task.class, (String)col);
            if (fld == null || fld.getAnnotation(Transient.class) != null) continue;
            try {
                rtn.put(col, fld.get(task));
            }
            catch (IllegalArgumentException e) {
                TaskExceptionCode.GET_OBJ_COLDATA.throwThisException(task.toString(), col, e.getMessage());
            }
            catch (IllegalAccessException e) {
                TaskExceptionCode.GET_OBJ_COLDATA.throwThisException(task.toString(), col, e.getMessage());
            }
        }
        return rtn;
    }

    @Override
    @Transactional
    public void batchSave(List<Task> taskList) {
        if (taskList == null) {
            return;
        }
        for (Task task : taskList) {
            this.save(task);
        }
    }

    @Override
    public Task checkTaskExist(Task task) {
        return this.findTaskByBillnoByTables(task.getEnt_id(), task.getBillno(), this.getNotCompletedTables());
    }

    @Override
    public Task findTaskByBillno(long entId, String billNO) {
        return this.findTaskByBillnoByTables(entId, billNO, this.getAllTableList());
    }

    public Task findTaskByBillnoByTables(long entId, String billNO, List<String> tables) {
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)entId);
        criteria.and("billno").is((Object)billNO);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        return (Task)this.findOneByTableList(query, tables, Utils.getTaskClass(entId));
    }

    private List<String> getAllTableList() {
        if (this.ALL_TASK_TABLE == null) {
            this.ALL_TASK_TABLE = new ArrayList<String>();
            this.ALL_TASK_TABLE.add(this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
            this.ALL_TASK_TABLE.add(this.getTableName(DataBaseConfigUtils.TASK_WAIT_SUB_TABLE_NAME));
            this.ALL_TASK_TABLE.add(this.getTableName(DataBaseConfigUtils.TASK_SUCCESS_TABLE_NAME));
            this.ALL_TASK_TABLE.add(this.getTableName(DataBaseConfigUtils.TASK_ERRORLIST_TABLE_NAME));
        }
        return this.ALL_TASK_TABLE;
    }

    private <T> T findOneByTableList(Query query, List<String> tables, Class<T> cls) {
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        for (String table : tables) {
            Object task = fso.selectOne(query, cls, table);
            if (task == null) continue;
            ((Task)task).setSrc_table(table);
            return (T)task;
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void logError(Task task, String message) {
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        Date now = new Date();
        task.setLast_exec_date(now);
        task.setLast_exec_error(message);
        if (task.getPh_timestamp() == null) {
            task.setPh_timestamp(now);
        }
        fso.insert((Object)task, this.getTableName(DataBaseConfigUtils.TASK_ERRORLOG_TABLE_NAME));
    }

    @Override
    @Transactional
    public void updateTask(Task task, String uptCols) {
        int rtn;
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)task.getPh_key()).and("task_status").lte((Object)task.getTask_status());
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        Update update = null;
        HashSet<String> keys = new HashSet<String>(Arrays.asList(uptCols.split(",")));
        try {
            update = StorageUtils.createUpdateFormBean((Object)task, keys);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ServiceException(TaskExceptionCode.GET_UPT_INFO_ERROR.getCode(), TaskExceptionCode.GET_UPT_INFO_ERROR.getMsgTemplate(), e.getMessage(), new Object[0]);
        }
        String tableName = this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME);
        if (task.getTask_status() == 99) {
            tableName = this.getTableName(DataBaseConfigUtils.TASK_WAIT_SUB_TABLE_NAME);
        }
        if (task.getSrc_table() != null && !task.getSrc_table().equalsIgnoreCase("MQ")) {
            tableName = task.getSrc_table();
        }
        if ((rtn = fso.update(queryByKey, update, tableName)) == 0) {
            ServiceLogs.truedebuglog((String)"TaskRepository", (String)"\u66f4\u65b0\u4efb\u52a1[{0}]\u72b6\u6001\u5230[{1}]\u65f6\u66f4\u65b0\u884c\u6570\u4e3a0", (long)0L, (Object[])new Object[]{task.getBillno(), task.getTask_status()});
        }
    }

    @Override
    @Transactional
    public Task findTaskById(long ent_id, long ph_key) {
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)ph_key).and("ent_id").is((Object)ent_id);
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        return (Task)fso.selectOne(queryByKey, Utils.getTaskClass(ent_id), this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
    }

    @Override
    @Transactional
    public void moveTaskToSuccess(Task task) {
        String table;
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)task.getPh_key());
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        task.setPh_timestamp(new Date());
        if (fso.count(queryByKey, this.getTableName(DataBaseConfigUtils.TASK_SUCCESS_TABLE_NAME)) <= 0L) {
            fso.insert((Object)task, this.getTableName(DataBaseConfigUtils.TASK_SUCCESS_TABLE_NAME));
        }
        if ((table = task.getSrc_table()).equalsIgnoreCase("MQ")) {
            table = this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME);
        }
        fso.delete(queryByKey, table);
        this.clearTaskErrorLog(task);
    }

    @Override
    @Transactional
    public void moveTaskToWaitSub(Task task) {
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)task.getPh_key());
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        task.setPh_timestamp(new Date());
        task.setExec_count(0);
        fso.insert((Object)task, this.getTableName(DataBaseConfigUtils.TASK_WAIT_SUB_TABLE_NAME));
        fso.delete(queryByKey, this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
        this.clearTaskErrorLog(task);
    }

    @Override
    @Transactional
    public void moveTaskToErrorList(Task task) {
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)task.getPh_key());
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        task.setPh_timestamp(new Date());
        fso.insert((Object)task, this.getTableName(DataBaseConfigUtils.TASK_ERRORLIST_TABLE_NAME));
        fso.delete(queryByKey, this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
        fso.delete(queryByKey, this.getTableName(DataBaseConfigUtils.TASK_WAIT_SUB_TABLE_NAME));
        this.clearTaskErrorLog(task);
    }

    @Override
    @Transactional
    public void clearTaskErrorLog(Task task) {
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)task.getPh_key());
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        List errlog = fso.select(queryByKey, Utils.getTaskClass(task.getEnt_id()), this.getTableName(DataBaseConfigUtils.TASK_ERRORLOG_TABLE_NAME));
        fso.delete(queryByKey, this.getTableName(DataBaseConfigUtils.TASK_ERRORLOG_TABLE_NAME));
        fso.insert((Collection)errlog, this.getTableName(DataBaseConfigUtils.HIS_TASK_ERRORLOG_TABLE_NAME));
    }

    @Override
    @Transactional
    public void insExecCompleteLog(Task task) {
        TaskExecCompleteLog log = new TaskExecCompleteLog(task);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        fso.insert((Object)log, this.getTableName(DataBaseConfigUtils.TASK_EXEC_COMPLETE_LOG));
    }

    @Override
    @Transactional
    public void delExecCompleteLog(Task task) {
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)task.getEnt_id()).and("billno").is((Object)task.getBillno());
        Query query = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        fso.delete(query, this.getTableName(DataBaseConfigUtils.TASK_EXEC_COMPLETE_LOG));
    }

    @Override
    public SubTaskStatusInfo querySubTaskStatus(long ent_id, String billno) {
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)ent_id).and("parent_billno").is((Object)billno);
        Query query = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        long successNum = fso.count(query, this.getTableName(DataBaseConfigUtils.TASK_SUCCESS_TABLE_NAME));
        long errNum = fso.count(query, this.getTableName(DataBaseConfigUtils.TASK_ERRORLIST_TABLE_NAME));
        long excingNum = fso.count(query, this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
        SubTaskStatusInfo rtn = new SubTaskStatusInfo(successNum, errNum, excingNum);
        return rtn;
    }

    @Override
    public boolean checkTaskIsExecComplete(Task task) {
        Criteria criteria = Criteria.where((String)"ent_id").is((Object)task.getEnt_id()).and("billno").is((Object)task.getBillno());
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        query.fields().include("billno");
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        Map rtn = fso.selectOne(query, this.getTableName(DataBaseConfigUtils.TASK_EXEC_COMPLETE_LOG));
        if (rtn == null || rtn.isEmpty()) {
            return false;
        }
        return rtn.size() > 0;
    }

    @Override
    public TaskErrorInfo queryTaskErrorInfo(long ph_key) {
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)ph_key);
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        queryByKey.fields().include("last_exec_date").include("last_exec_error");
        queryByKey.with(new Sort(Sort.Direction.DESC, new String[]{"last_exec_date"}));
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        List errLog = fso.select(queryByKey, this.getTableName(DataBaseConfigUtils.TASK_ERRORLOG_TABLE_NAME));
        int count = errLog.size();
        long lastDate = 0L;
        String LastMsg = null;
        if (count > 0) {
            lastDate = Long.valueOf(((Map)errLog.get(0)).get("last_exec_date").toString());
            LastMsg = (String)((Map)errLog.get(0)).get("last_exec_error");
        }
        TaskErrorInfo rtn = new TaskErrorInfo(count, lastDate, LastMsg);
        return rtn;
    }

    @Override
    public void updateSubTaskStatus(String billNo, int status) {
        Criteria criteria = Criteria.where((String)"billno").is((Object)billNo);
        criteria.orOperator(new Criteria[]{Criteria.where((String)"parent_billno").is((Object)billNo)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("task_status", (Object)status);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        List<String> tables = this.getNotCompletedTables();
        for (String table : tables) {
            fso.update(query, update, table);
        }
    }

    @Override
    public List<Task> querySubTaskNotLast(String billNo) {
        Criteria criteria = Criteria.where((String)"isMainTask").ne((Object)"L");
        criteria.andOperator(new Criteria[]{Criteria.where((String)"billno").is((Object)billNo).orOperator(new Criteria[]{Criteria.where((String)"parent_billno").is((Object)billNo)})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1000);
        List<String> tables = this.getNotCompletedTables();
        List<Task> taskList = this.queryFromTables(query, tables);
        return taskList;
    }

    @Override
    public List<Task> queryUnfinishedTaskInfo(Date startDate, Date endDate, long lastPhkey) {
        Criteria criteria = null;
        criteria = startDate != null ? Criteria.where((String)"ph_timestamp").lte((Object)endDate).gte((Object)startDate) : Criteria.where((String)"ph_timestamp").lte((Object)endDate);
        criteria.and("ph_key").gt((Object)lastPhkey);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1000);
        query.with(new Sort(Sort.Direction.ASC, new String[]{"ph_timestamp", "ph_key"}));
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        String table = this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME);
        List taskList = fso.select(query, Utils.getTaskClass(0L), table);
        for (Task task : taskList) {
            task.setSrc_table(table);
        }
        return taskList;
    }

    @Override
    public List<Task> queryWaitSubTaskInfo(Date startDate, Date endDate, long lastPhkey) {
        Criteria criteria = null;
        criteria = startDate != null ? Criteria.where((String)"ph_timestamp").lte((Object)endDate).gte((Object)startDate) : Criteria.where((String)"ph_timestamp").lte((Object)endDate);
        criteria.and("ph_key").gt((Object)lastPhkey);
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1000);
        query.with(new Sort(Sort.Direction.ASC, new String[]{"ph_timestamp", "ph_key"}));
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        String table = this.getTableName(DataBaseConfigUtils.TASK_WAIT_SUB_TABLE_NAME);
        List taskList = fso.select(query, Task.class, table);
        for (Task task : taskList) {
            task.setSrc_table(table);
        }
        return taskList;
    }

    @Override
    public List<Task> queryTaskList(JSONObject condition) {
        String status = condition.getString("task_status");
        condition.remove((Object)"task_status");
        Query query = StorageUtils.createQueryFormJson((JSONObject)condition, Task.class);
        ArrayList<String> tables = new ArrayList<String>();
        if (status.equalsIgnoreCase("3")) {
            tables.add(DataBaseConfigUtils.getTableName(DataBaseConfigUtils.TASK_ERRORLIST_TABLE_NAME));
        } else if (status.equalsIgnoreCase("1")) {
            tables.add(DataBaseConfigUtils.getTableName(DataBaseConfigUtils.TASK_SUCCESS_TABLE_NAME));
        } else {
            tables.addAll(this.getNotCompletedTables());
        }
        List<Task> taskList = this.queryFromTables(query, tables);
        return taskList;
    }

    @Override
    public Map<String, Long> queryFailedTaskErrorGroup(Date startDay, Date endDay) {
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        FMybatisTemplate ft = (FMybatisTemplate)fso;
        String table = this.getTableName(DataBaseConfigUtils.TASK_ERRORLIST_TABLE_NAME);
        String sDay = DateFormatUtils.format((Date)startDay, (String)"yyyy-MM-dd");
        String eDay = DateFormatUtils.format((Date)endDay, (String)"yyyy-MM-dd");
        String sql = "select last_exec_errorGroup errorGrp,count(*) grpCount from " + table + " ";
        sql = sql + "where ph_timestamp >='" + sDay + "' and ph_timestamp < '" + eDay + "' ";
        sql = sql + "group by last_exec_errorGroup";
        List rtn = ft.getSqlSessionTemplate().selectList("select", (Object)sql);
        HashMap<String, Long> rtnMap = new HashMap<String, Long>();
        for (Map row : rtn) {
            rtnMap.put(MapUtils.getString((Map)row, (String)"errorGrp"), MapUtils.getLongValue((Map)row, (String)"grpCount", (long)0L));
        }
        return rtnMap;
    }

    @Override
    public long querySucceedTaskCount(Date startDay, Date endDay) {
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        String table = this.getTableName(DataBaseConfigUtils.TASK_SUCCESS_TABLE_NAME);
        Criteria criteria = Criteria.where((String)"ph_timestamp").lt((Object)endDay).gte((Object)startDay);
        Query query = new Query((CriteriaDefinition)criteria);
        return fso.count(query, table);
    }

    private List<Task> queryFromTables(Query query, List<String> tables) {
        ArrayList<Task> taskList = new ArrayList<Task>();
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        for (String table : tables) {
            List qtask = fso.select(query, Task.class, table);
            for (Task task : qtask) {
                task.setSrc_table(table);
            }
            taskList.addAll(qtask);
        }
        return taskList;
    }

    private List<String> getNotCompletedTables() {
        if (this.notCompletedTaskTables == null) {
            this.notCompletedTaskTables = new ArrayList<String>();
            this.notCompletedTaskTables.add(this.getTableName(DataBaseConfigUtils.TASK_UNFINISHED_TABLE_NAME));
            this.notCompletedTaskTables.add(this.getTableName(DataBaseConfigUtils.TASK_WAIT_SUB_TABLE_NAME));
        }
        return this.notCompletedTaskTables;
    }
}

