/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.service;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.TaskWorker;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.exception.TaskExceptionCode;
import org.springframework.stereotype.Component;

@Component(value="defaultTaskMessageConsumer")
public class TaskMessageConsumer {
    public int consume(Task task) {
        return this.runTask(task);
    }

    public int runTask(Task task) {
        TaskWorker taskWorker = null;
        try {
            taskWorker = this.getTaskWorker(task);
        }
        catch (Exception e) {
            TaskComponentFactory.getTaskManager().handleError(task, e);
            return -1;
        }
        taskWorker.receiveTask(task);
        return 0;
    }

    private TaskWorker getTaskWorker(Task task) {
        TaskWorker worker = TaskComponentFactory.getTaskWorkerFactory().getWorker(task.getTask_group(), task.getTask_type());
        if (worker == null) {
            throw new ServiceException(TaskExceptionCode.NO_WORKER.getCode(), TaskExceptionCode.NO_WORKER.getMsgTemplate(), task.getTask_group() + "-" + task.getTask_type(), new Object[0]);
        }
        return worker;
    }
}

