/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.service;

import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.exception.TaskExceptionCode;
import org.springframework.stereotype.Component;

@Component
public class TaskService {
    public int run(Task task) {
        return this.run(task, 0);
    }

    public int stop(long entId, String billNo) {
        Task task = TaskComponentFactory.getTaskRepository().findTaskByBillno(entId, billNo);
        if (task == null) {
            TaskExceptionCode.NO_TASKINFO.throwThisException(billNo);
        }
        TaskComponentFactory.getTaskStatusManager().stop(task);
        return 0;
    }

    public int run(Task task, int runMode) {
        task.setRun_mode(runMode);
        if (task.getData() == null) {
            Object data = TaskComponentFactory.getTaskDataQuery().getTaskData(task);
            if (data == null) {
                TaskExceptionCode.NOT_FIND_TASKDATA.throwThisException(task.getBillno());
            }
            task.setData(data);
        }
        if (runMode == 2) {
            TaskComponentFactory.getTaskRepository().delExecCompleteLog(task);
            TaskComponentFactory.getTaskStatusManager().clearCachedStatus(task);
        }
        return TaskComponentFactory.getTaskMessageConsumer().consume(task);
    }
}

