/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.job.TaskJob;
import com.efuture.taskflow.monitoring.TaskMonitorService;
import com.efuture.taskflow.monitoring.TaskSummary;
import com.efuture.taskflow.repository.TaskRepository;
import com.efuture.taskflow.service.TaskService;
import com.efuture.taskflow.utils.Utils;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ocp.task.service")
public class TaskServiceControl {
    @Autowired
    TaskService service;
    @Autowired
    TaskJob taskJob;
    @Autowired
    TaskMonitorService taskMonitorSrv;

    public ServiceResponse checkTaskStatus(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        String taskBillno = jsonparam.getString("billno");
        return ServiceResponse.buildSuccess((Object)this.taskJob.checkTaskStatus(session.getEnt_id(), taskBillno));
    }

    public ServiceResponse stop(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        String taskBillno = jsonparam.getString("billno");
        this.service.stop(session.getEnt_id(), taskBillno);
        return ServiceResponse.buildSuccess((Object)"OK");
    }

    public ServiceResponse retry(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Task task = (Task)JSONObject.toJavaObject((JSON)jsonparam, Task.class);
        this.service.run(task, task.getRun_mode());
        return ServiceResponse.buildSuccess((Object)"OK");
    }

    public ServiceResponse retryByBillno(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        String billno = jsonparam.getString("billno");
        if (billno == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"billno", (Object[])new Object[0]);
        }
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        Task task = repository.findTaskByBillno(session.getEnt_id(), billno);
        task.setTask_status(0);
        task.setRun_mode(2);
        this.service.run(task, task.getRun_mode());
        return ServiceResponse.buildSuccess((Object)"OK");
    }

    public ServiceResponse queryUnfinishedTaskInfo(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Date startDate = jsonparam.getDate("start_date");
        Date endDate = jsonparam.getDate("end_date");
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess(repository.queryUnfinishedTaskInfo(startDate, endDate, 0L));
    }

    public ServiceResponse queryWaitSubTaskInfo(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Date startDate = jsonparam.getDate("start_date");
        Date endDate = jsonparam.getDate("end_date");
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess(repository.queryWaitSubTaskInfo(startDate, endDate, 0L));
    }

    public ServiceResponse queryTaskList(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess(repository.queryTaskList(jsonparam));
    }

    public ServiceResponse queryTaskSummary(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Date startDay = jsonparam.getDate("start_day");
        Date endDay = jsonparam.getDate("end_day");
        TaskSummary summary = this.taskMonitorSrv.getTaskSummary(startDay, endDay);
        return ServiceResponse.buildSuccess((Object)summary);
    }

    public ServiceResponse findTaskByBillno(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        String billno = jsonparam.getString("billno");
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess((Object)repository.findTaskByBillno(session.getEnt_id(), billno));
    }

    public ServiceResponse testMsg(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Message msg = (Message)JSONObject.toJavaObject((JSON)jsonparam, Message.class);
        Task task = Utils.convertMessageToTask(msg);
        this.service.run(task);
        return ServiceResponse.buildSuccess((Object)"OK");
    }

    public ServiceResponse testTask(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Task task = (Task)JSONObject.toJavaObject((JSON)jsonparam, (Class)Utils.getTaskClass(session.getEnt_id()));
        this.service.run(task);
        return ServiceResponse.buildSuccess((Object)"OK");
    }
}

