/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.taskdata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.param.TaskParam;
import com.efuture.taskflow.taskdata.TaskDataQuery;
import com.efuture.taskflow.utils.Utils;
import java.util.Date;
import java.util.List;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.stereotype.Component;

@Component(value="defaultTaskDataQuery")
public class TaskDataQueryByTaskExecuter
implements TaskDataQuery {
    String logtype = "TaskDataQuery";

    @Override
    public Object getTaskData(Task task) {
        if (task.getData() != null) {
            return task.getData();
        }
        Object data = TaskComponentFactory.getTaskDataRepository().query(task.getEnt_id(), task.getPh_key());
        if (data != null) {
            return data;
        }
        ServiceLogs.debuglog((String)this.logtype, (String)"\u672a\u80fd\u4ece\u6570\u636e\u5e93\u4e2d\u83b7\u53d6\u4efb\u52a1[{0}]\u7684\u4efb\u52a1\u6570\u636e", (long)0L, (Object[])new Object[]{task.getPh_key()});
        data = this.getFromMq(task);
        if (data != null) {
            return data;
        }
        return TaskComponentFactory.getTaskWorkerFactory().getWorker(task.getTask_group(), task.getTask_type()).getTaskExecuter().getTaskDataByTaskInfo(task);
    }

    private Object getFromMq(Task task) {
        DefaultMQProducer mqp = null;
        try {
            mqp = (DefaultMQProducer)SpringBeanFactory.getContext().getBean(DefaultMQProducer.class);
            if (mqp == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        String topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(0L);
        String key = topic + "-" + task.getBillno();
        long begin = task.getPh_timestamp().getTime() - 3600000L;
        long end = new Date().getTime();
        try {
            QueryResult qr = mqp.queryMessage(TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(0L), key, 10, begin, end);
            List messageList = qr.getMessageList();
            if (messageList == null || messageList.size() == 0) {
                ServiceLogs.debuglog((String)this.logtype, (String)"\u672a\u80fd\u4eceMQ\u83b7\u53d6\u4efb\u52a1[{0}]\u7684\u4efb\u52a1\u6570\u636e", (long)0L, (Object[])new Object[]{key});
                return null;
            }
            if (messageList.size() > 1) {
                ServiceLogs.debuglog((String)this.logtype, (String)"\u4eceMQ\u83b7\u53d6\u4efb\u52a1[{0}]\u7684\u4efb\u52a1\u6570\u636e\u5b58\u5728\u591a\u4e2a\u76f8\u540ckey\u7684\u4efb\u52a1\u6570\u636e\u5b58\u5728,\u5c06\u8fd4\u56de\u7b2c\u4e00\u884c\u6570\u636e", (long)0L, (Object[])new Object[]{key});
            }
            MessageExt msgExt = (MessageExt)messageList.get(0);
            JSONObject jobj = (JSONObject)JSONObject.parse((byte[])msgExt.getBody(), (Feature[])new Feature[0]);
            Message msg = (Message)JSONObject.toJavaObject((JSON)jobj, Message.class);
            Task mqTask = Utils.convertMessageToTask(msg);
            return mqTask.getData();
        }
        catch (MQClientException e) {
            ServiceLogs.errLog((String)this.logtype, (Exception)((Object)e), (String)"\u4eceMQ\u83b7\u53d6\u4efb\u52a1[{0}]\u7684\u4efb\u52a1\u6570\u636e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a[{1}]", (Object[])new Object[]{key, e.getMessage()});
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

