/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.taskdata;

import com.efuture.omd.storage.FStorageOperations;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.entity.TaskDataBean;
import com.efuture.taskflow.taskdata.TaskDataRepository;
import com.efuture.taskflow.utils.DataBaseConfigUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="taskDataRepositoryByDb")
public class TaskDataRepositoryImpl
implements TaskDataRepository {
    @Override
    @Transactional
    public void save(Task task) {
        TaskDataBean dataBean = new TaskDataBean(task);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)task.getPh_key()).and("ent_id").is((Object)task.getEnt_id());
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        String tableName = DataBaseConfigUtils.getTableName(DataBaseConfigUtils.TASK_DATA_LIST);
        fso.delete(queryByKey, tableName);
        fso.insert((Object)dataBean, tableName);
    }

    @Override
    public String query(long entId, long phKey) {
        Criteria criteria = Criteria.where((String)"ph_key").is((Object)phKey).and("ent_id").is((Object)entId);
        Query queryByKey = new Query((CriteriaDefinition)criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        TaskDataBean taskdata = (TaskDataBean)fso.selectOne(queryByKey, TaskDataBean.class, DataBaseConfigUtils.getTableName(DataBaseConfigUtils.TASK_DATA_LIST));
        if (taskdata == null) {
            return null;
        }
        return taskdata.getTaskdata();
    }
}

