/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.taskmanager;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.TaskManager;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.exception.TaskExceptionCode;
import com.efuture.taskflow.param.TaskParam;
import com.efuture.taskflow.taskmanager.TaskStatusManager;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="defaultTaskManager")
public class TaskManagerImpl
implements TaskManager {
    TaskStatusManager taskStatusManager;

    private TaskStatusManager getTaskStatusManager() {
        if (this.taskStatusManager == null) {
            this.taskStatusManager = TaskComponentFactory.getTaskStatusManager();
        }
        return this.taskStatusManager;
    }

    @Override
    public void handleError(Task task, Exception e) {
        String msg = "taskgroup:[{0}],tasktype:[{1}],taskbillno:[{2}]";
        ServiceLogs.errLog((String)"TaskManager", (Exception)e, (String)msg, (Object[])new Object[]{task.getTask_group(), task.getTask_type(), task.getBillno()});
        String errorGroup = "unknown";
        String errorCode = TaskExceptionCode.NOT_HANDLE_ERROR.getCode();
        String errorMsg = e.getMessage();
        if (e instanceof ServiceException) {
            ServiceException se = (ServiceException)e;
            errorGroup = se.getErrGroup();
            errorCode = se.getErrorCode();
        }
        task.setLast_exec_errorCode(errorGroup, errorCode);
        task.setLast_exec_date(new Date());
        task.setLast_exec_error(errorMsg);
        if (Long.valueOf(errorCode) >= 100000L || errorGroup.equalsIgnoreCase("ignore")) {
            ServiceLogs.errLog((String)"TaskManager", (Exception)e, (String)("\u5ffd\u7565\u5f02\u5e38:" + msg), (Object[])new Object[]{task.getTask_group(), task.getTask_type(), task.getBillno()});
            task.setTask_status(303);
            TaskComponentFactory.getTaskRepository().moveTaskToErrorList(task);
            return;
        }
        if (StringUtils.isEmpty((Object)errorMsg)) {
            StackTraceElement[] stackTrace = e.getStackTrace();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < stackTrace.length; ++i) {
                sb.append(stackTrace[i]);
                if (i >= 3) break;
            }
            errorMsg = sb.toString();
        }
        if (!this.isMaxRetry(task)) {
            TaskComponentFactory.getTaskRepository().logError(task, errorMsg);
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException(TaskExceptionCode.NOT_HANDLE_ERROR.getCode(), TaskExceptionCode.NOT_HANDLE_ERROR.getMsgTemplate(), errorMsg, new Object[0]);
        }
        ServiceLogs.errLog((String)"TaskManager", (Exception)e, (String)("\u8d85\u8fc7\u91cd\u8bd5\u6b21\u6570:" + msg), (Object[])new Object[]{task.getTask_group(), task.getTask_type(), task.getBillno()});
        task.setTask_status(301);
        TaskComponentFactory.getTaskRepository().moveTaskToErrorList(task);
        TaskComponentFactory.getTaskDataRepository().save(task);
    }

    private boolean isMaxRetry(Task task) {
        int max = TaskParam.TASK_PUBLIC.MAX_RETRY_COUNT.getIntVal(task.getEnt_id());
        return task.getExec_count() >= max;
    }

    @Override
    public void syncTaskInfo(Task task) {
        this.getTaskStatusManager().syncTaskStatus(task);
    }

    @Override
    public void savaStat(Task task, int newStatus) {
        this.getTaskStatusManager().taskStatusChanged(task, newStatus);
    }

    @Override
    public int sendTask(List<Task> listSubTask) {
        if (listSubTask == null) {
            return 0;
        }
        return TaskComponentFactory.getTaskQueueService().batchProduct(listSubTask);
    }

    @Override
    public Task save(Task task) {
        return TaskComponentFactory.getTaskRepository().save(task);
    }

    @Override
    public int delete(Task task) {
        return 0;
    }

    @Override
    public void batchSave(List<Task> taskList) {
        if (taskList == null) {
            return;
        }
        TaskComponentFactory.getTaskRepository().batchSave(taskList);
    }

    @Override
    public void start() {
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void onExecComplete(Task task) {
        if (task.getTask_status() != 202) {
            TaskComponentFactory.getTaskRepository().insExecCompleteLog(task);
        }
    }

    @Override
    public boolean taskIsExecCompleted(Task task) {
        if (task.getRun_mode() == 2) {
            return false;
        }
        return TaskComponentFactory.getTaskRepository().checkTaskIsExecComplete(task);
    }

    @Override
    public void sendTask(Task task) {
        TaskComponentFactory.getTaskQueueService().product(task);
    }
}

