/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.taskmanager;

import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.entity.InterTaskStatus;
import com.efuture.taskflow.entity.SubTaskStatusInfo;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.entity.TaskErrorInfo;
import com.efuture.taskflow.exception.TaskExceptionCode;
import com.efuture.taskflow.param.TaskParam;
import com.efuture.taskflow.repository.TaskRepository;
import com.efuture.taskflow.taskdata.TaskDataQuery;
import com.efuture.taskflow.taskmanager.TaskStatusChangeEvent;
import com.efuture.taskflow.taskmanager.TaskStatusManager;
import com.efuture.taskflow.work.TaskWorkerFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="defaultTaskStatusManager")
public class TaskStatusManagerImpl
implements TaskStatusManager {
    public static String logtype = "TaskStatusManager";
    LinkedBlockingQueue<TaskStatusChangeEvent> taskStatusChangedEvents = new LinkedBlockingQueue(50000);
    @Autowired
    TaskRepository taskRepo;
    boolean ibExit = false;
    Thread taskStatusChangedHandleThread = null;

    public TaskStatusManagerImpl() {
        this.start();
    }

    public TaskRepository getTaskRepo() {
        return this.taskRepo;
    }

    @Override
    public void taskStatusChanged(Task task, int newStatus) {
        int oldStatus = task.getTask_status();
        if (newStatus == 99 && task.getTot_subtask_num() == 0) {
            newStatus = 200;
        }
        task.setTask_status(newStatus);
        this.setValToCached(task.getStatusKey(), task.getStatusValue());
        TaskStatusChangeEvent event = new TaskStatusChangeEvent(task, oldStatus);
        this.publishEvent(event);
    }

    private TaskStatusManager getTaskStatusManager() {
        return TaskComponentFactory.getTaskStatusManager();
    }

    private TaskWorkerFactory getTaskWorkerFactory() {
        return TaskComponentFactory.getTaskWorkerFactory();
    }

    private TaskDataQuery getTaskDataQuery() {
        return TaskComponentFactory.getTaskDataQuery();
    }

    public void publishEvent(TaskStatusChangeEvent event) {
        if (event.isSaveImmediately()) {
            try {
                this.getTaskStatusManager().updateTask(event.getTask(), event.getOldStatus());
            }
            catch (Exception e) {
                ServiceLogs.errLog((String)logtype, (Exception)e, (String)"\u66f4\u65b0task[{0}]\u72b6\u6001\u65f6\u9519\u8bef,\u653e\u5165\u7f13\u51b2\u961f\u5217", (Object[])new Object[]{event.getTask().getBillno()});
                this.taskStatusChangedEvents.add(event);
            }
        } else {
            this.taskStatusChangedEvents.add(event);
        }
    }

    private void start() {
        this.taskStatusChangedHandleThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TaskStatusManagerImpl.this.doHandleTaskStatusChanged();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, "taskStatusChangedHandle");
        this.taskStatusChangedHandleThread.start();
    }

    @Override
    @DLock(key="#args[0].getLockKey()")
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void refreshTaskStatus(Task task) {
        if ((task = this.syncTaskStatus(task)).isNotStart()) {
            this.handleNotStartTaskStatus(task);
        } else if (task.isExecing()) {
            this.handleExecingTaskStatus(task);
        } else if (task.isWaitSubComplete()) {
            this.handleWaitSubCompleteTaskStatus(task);
        } else if (task.isStoped()) {
            this.handleStopTaskStatus(task);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void refreshTaskError(Task task, String errMsg) {
        int needCheckCount = TaskParam.TASK_PUBLIC.MAX_CHECK_COUNT.getIntVal(task.getEnt_id());
        task.setExec_count(task.getExec_count() + 1);
        task.setLast_exec_error(errMsg);
        task.setLast_exec_date(System.currentTimeMillis() / 1000L);
        if (task.getExec_count() > needCheckCount) {
            this.onOverMaxCheckTimes(task);
        } else {
            String uptCols = "last_exec_date,exec_count,last_exec_error";
            this.getTaskRepo().updateTask(task, uptCols);
        }
    }

    private void handleStopTaskStatus(Task task) {
        this.onAllComplete(task);
    }

    private void handleWaitSubCompleteTaskStatus(Task task) {
        if (task.isWaitSubComplete()) {
            this.checkSubTaskStatus(task);
        }
    }

    private void doMoveToErrorList(Task task) {
        this.getTaskRepo().moveTaskToErrorList(task);
    }

    private void doUpdateSubtaskStatus(Task task) {
        String uptCols = "success_subtask_num,error_subtask_num,exec_count";
        this.getTaskRepo().updateTask(task, uptCols);
    }

    private void checkSubTaskStatus(Task task) {
        int checkCount = task.getExec_count();
        int needCheckCount = TaskParam.TASK_PUBLIC.MAX_CHECK_COUNT.getIntVal(task.getEnt_id());
        SubTaskStatusInfo subTaskInfo = this.getTaskRepo().querySubTaskStatus(task.getEnt_id(), task.getBillno());
        task.setSubTaskStatusInfo(subTaskInfo);
        if (task.isAllSubCompleted()) {
            this.onAllComplete(task);
        } else if (checkCount >= needCheckCount) {
            this.onOverMaxCheckTimes(task);
        } else {
            task.setExec_count(checkCount + 1);
            this.doUpdateSubtaskStatus(task);
        }
    }

    private void handleExecingTaskStatus(Task task) {
        if (task.hasSub()) {
            this.checkSubTaskStatus(task);
        } else {
            this.checkThisTaskStatus(task);
        }
    }

    private void onOvertime(Task task) {
        task.setTask_status(304);
        this.doMoveToErrorList(task);
    }

    private void onOverMaxCheckTimes(Task task) {
        task.setTask_status(301);
        this.doMoveToErrorList(task);
    }

    private void checkThisTaskStatus(Task task) {
        if (this.getTaskRepo().checkTaskIsExecComplete(task)) {
            this.onAllComplete(task);
        } else {
            TaskErrorInfo errorInfo = this.getTaskRepo().queryTaskErrorInfo(task.getPh_key());
            long thisTime = new Date().getTime() - (long)(TaskParam.TASK_PUBLIC.TASK_TIMEOUT_HOURS.getIntVal(task.getEnt_id()) * 60 * 60 * 1000);
            if (thisTime >= errorInfo.getLastExecDate()) {
                this.onOvertime(task);
                return;
            }
            if (errorInfo.getErrorCount() == 0) {
                task.setExec_count(task.getExec_count() + 1);
            } else {
                task.setExec_count(errorInfo.getErrorCount());
            }
            task.setLast_exec_date(errorInfo.getLastExecDate());
            task.setLast_exec_error(errorInfo.getLastExecError());
            String uptCols = "exec_count,last_exec_date,last_exec_error";
            int checkCount = task.getExec_count();
            int needCheckCount = TaskParam.TASK_PUBLIC.MAX_CHECK_COUNT.getIntVal(task.getEnt_id());
            if (checkCount >= needCheckCount) {
                this.onOverMaxCheckTimes(task);
            } else {
                this.getTaskRepo().updateTask(task, uptCols);
            }
        }
    }

    private void handleNotStartTaskStatus(Task task) {
        block8: {
            int checkCount = task.getExec_count();
            int needCheckCount = TaskParam.TASK_PUBLIC.MAX_CHECK_COUNT.getIntVal(task.getEnt_id());
            try {
                Date startDate = task.getPh_timestamp();
                Date now = new Date();
                int startTimeout = TaskParam.TASK_PUBLIC.START_TIMEOUT_MINS.getIntVal(task.getEnt_id());
                long thisMins = (now.getTime() - startDate.getTime()) / 1000L / 60L;
                if (thisMins < (long)startTimeout) break block8;
                try {
                    Object data = this.getTaskDataQuery().getTaskData(task);
                    if (data == null) {
                        TaskExceptionCode.GET_TASKDATA_ERROR.throwThisException(task.getBillno(), "\u672a\u77e5\u539f\u56e0");
                        return;
                    }
                    task.setData(data);
                }
                catch (ServiceException e) {
                    throw e;
                }
                catch (Exception e) {
                    TaskExceptionCode.GET_TASKDATA_ERROR.throwThisException(task.getBillno(), e.getMessage());
                    return;
                }
                if (task.getData() != null) {
                    this.getTaskWorkerFactory().getWorker(task.getTask_group(), task.getTask_type()).receiveTask(task);
                }
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                ServiceLogs.errLog((String)logtype, (Exception)e, (String)"\u91cd\u542f\u542f\u52a8[{0}]\u4efb\u52a1\u65f6\u9519\u8bef,\u9519\u8bef\u4fe1\u606f[{1}]", (Object[])new Object[]{task.getBillno(), e.getMessage()});
                TaskExceptionCode.GET_TASKDATA_ERROR.throwThisException(task.getBillno(), e.getMessage());
            }
        }
    }

    @Override
    public Task syncTaskStatus(Task task) {
        if (task.getRun_mode() == 2) {
            return task;
        }
        String statusVal = this.getValFromCached(task.getStatusKey());
        String parentStatusVal = this.getValFromCached(task.getParentStatusKey());
        if (statusVal != null) {
            InterTaskStatus PStatus;
            if (parentStatusVal != null && (PStatus = task.convertToTaskStatus(parentStatusVal)).getTask_status() == 302) {
                this.taskStatusChanged(task, 302);
                return task;
            }
            int oldStatus = task.getTask_status();
            boolean ibStatuChanged = task.setStatusValue(statusVal);
            if (ibStatuChanged) {
                int newStatus = task.getTask_status();
                task.setTask_status(oldStatus);
                this.taskStatusChanged(task, newStatus);
            }
        } else {
            Task exTask = this.taskRepo.findTaskById(task.getEnt_id(), task.getPh_key());
            if (exTask != null) {
                task.setStatusValue(exTask.getStatusValue());
                this.setValToCached(task.getStatusKey(), task.getStatusValue());
            }
        }
        return task;
    }

    protected void doHandleTaskStatusChanged() throws InterruptedException {
        do {
            try {
                List<TaskStatusChangeEvent> events = this.getTaskStatusChangedEvents();
                this.changeStatus(events);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Thread.sleep(10000L);
        } while (!this.ibExit);
    }

    private void changeStatus(List<TaskStatusChangeEvent> events) {
        long time = System.currentTimeMillis();
        ServiceLogs.truedebuglog((String)logtype, (String)"\u83b7\u53d6\u5230[{0}]\u6761\u72b6\u6001\u53d8\u66f4", (long)0L, (Object[])new Object[]{events.size()});
        HashMap<String, TaskStatusChangeEvent> billMap = new HashMap<String, TaskStatusChangeEvent>();
        for (TaskStatusChangeEvent event : events) {
            String key = event.getTask().getBillno();
            TaskStatusChangeEvent oldEvent = (TaskStatusChangeEvent)((Object)billMap.get(key));
            if (oldEvent != null && oldEvent.getTimestamp() >= event.getTimestamp()) continue;
            billMap.put(key, event);
        }
        ServiceLogs.truedebuglog((String)logtype, (String)"\u5408\u5e76\u540e\u8fd8\u6709[{0}]\u6761\u72b6\u6001\u53d8\u66f4", (long)time, (Object[])new Object[]{billMap.size()});
        int errorNum = 0;
        for (TaskStatusChangeEvent event : billMap.values()) {
            try {
                this.getTaskStatusManager().updateTask(event.getTask(), event.getOldStatus());
            }
            catch (Exception e) {
                ++errorNum;
            }
        }
        ServiceLogs.truedebuglog((String)logtype, (String)"\u5904\u7406[{0}]\u6761\u72b6\u6001\u53d8\u66f4,\u5931\u8d25[{1}]\u6761", (long)time, (Object[])new Object[]{billMap.size(), errorNum});
    }

    @Transactional
    public void onAllComplete(Task task) {
        this.getTaskRepo().moveTaskToSuccess(task);
        TaskComponentFactory.getTaskWorkerFactory().getWorker(task.getTask_group(), task.getTask_type()).onComplete(task);
    }

    @Transactional
    public void onWaitSubComplete(Task task) {
        this.getTaskRepo().moveTaskToWaitSub(task);
    }

    @Transactional
    public void updateToDb(Task task) {
        String uptCols = "task_status";
        if (task.getExecReturn() != null && task.getExecReturn().getNeedUpdateCols() != null) {
            uptCols = uptCols + "," + task.getExecReturn().getNeedUpdateCols();
        }
        this.getTaskRepo().updateTask(task, uptCols);
    }

    private List<TaskStatusChangeEvent> getTaskStatusChangedEvents() {
        ArrayList<TaskStatusChangeEvent> events = new ArrayList<TaskStatusChangeEvent>(10000);
        this.taskStatusChangedEvents.drainTo(events, 10000);
        return events;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateTask(Task task, int oldStatus) {
        try {
            if (task.getTask_status() == 99) {
                this.onWaitSubComplete(task);
            } else if (task.getTask_status() == 200) {
                this.onAllComplete(task);
            } else {
                this.updateToDb(task);
            }
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)logtype, (Exception)e, (String)"\u66f4\u65b0\u4efb\u52a1[{0}]\u72b6\u6001\u5931\u8d25", (Object[])new Object[]{task.getBillno()});
            throw e;
        }
    }

    private String getValFromCached(String key) {
        Object obj = CacheUtils.getCacheUtils().getData(key);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    private void setValToCached(String key, String val, int mins) {
        CacheUtils.getCacheUtils().putData(key, (Object)val, mins * 60);
    }

    private void setValToCached(String key, String val) {
        this.setValToCached(key, val, 1440);
    }

    @Override
    public void faildown(Task task, int errStatus) {
        task.setTask_status(errStatus);
        this.getTaskRepo().moveTaskToErrorList(task);
    }

    @Override
    public void clearCachedStatus(Task task) {
        CacheUtils.getCacheUtils().deleteData(task.getStatusKey());
    }

    @Override
    public void stop(Task task) {
        this.getTaskRepo().updateSubTaskStatus(task.getBillno(), 302);
        List<Task> listSubTask = this.getTaskRepo().querySubTaskNotLast(task.getBillno());
        for (Task subTask : listSubTask) {
            subTask.setTask_status(302);
            this.setValToCached(subTask.getStatusKey(), subTask.getStatusValue());
        }
    }
}

