/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.work;

import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.taskflow.CreateSubTaskCallBack;
import com.efuture.taskflow.TaskExecuter;
import com.efuture.taskflow.TaskManager;
import com.efuture.taskflow.TaskStreamCreateSubTask;
import com.efuture.taskflow.TaskWorker;
import com.efuture.taskflow.entity.ExecReturn;
import com.efuture.taskflow.entity.Task;
import java.util.List;

public class StandardTaskWorker
implements TaskWorker {
    String logtype = "StandardTaskWorker";
    TaskExecuter executer;
    TaskManager taskManager;

    public StandardTaskWorker(TaskExecuter executer, TaskManager taskManager) {
        this.executer = executer;
        this.taskManager = taskManager;
    }

    @Override
    @DLock(key="#args[0].getLockKey()")
    public int receiveTask(Task task) {
        try {
            int rtn = this.onReceiveTask(task);
            if (rtn == 1) {
                if (!task.isThisComplete()) {
                    this.execTask(task);
                    this.savaStat(task, 99);
                }
            } else {
                task.setTask_status(rtn);
                ServiceLogs.debuglog((String)this.logtype, (String)String.format("onReceiveTask\u8fd4\u56de\u503c[%d],\u4e0d\u6267\u884c,Task.billno[%s]", rtn, task.getBillno()), (long)0L);
            }
            this.taskManager.onExecComplete(task);
        }
        catch (Exception e) {
            this.taskManager.handleError(task, e);
        }
        return task.getTask_status();
    }

    private int onReceiveTask(Task task) {
        if (this.taskManager.taskIsExecCompleted(task)) {
            ServiceLogs.debuglog((String)this.logtype, (String)"\u4efb\u52a1[{0}]\u5df2\u7ecf\u6267\u884c\u8fc7\uff0c\u4e0d\u91cd\u590d\u6267\u884c", (long)0L, (Object[])new Object[]{task.getBillno()});
            return 202;
        }
        this.syncTaskInfo(task);
        return 1;
    }

    @Override
    public int execTask(Task task) {
        if (!task.isExecComplete()) {
            this.doExec(task);
        }
        if (!task.isCreateSubComplete()) {
            this.savaStat(task, 50);
            if (this.executer instanceof TaskStreamCreateSubTask) {
                this.streamcreateSubTask(task);
            } else {
                this.createSubTask(task);
            }
            this.savaStat(task, 59);
        }
        return ExecReturn.EXEC_STATUS.SUCESS.getValue();
    }

    private void streamcreateSubTask(final Task task) {
        TaskStreamCreateSubTask create = (TaskStreamCreateSubTask)((Object)this.executer);
        create.createSubTask(task, new CreateSubTaskCallBack(){

            @Override
            public void callBack(Task subTask) {
                task.setTot_subtask_num(task.getTot_subtask_num() + 1);
                StandardTaskWorker.this.taskManager.save(subTask);
                StandardTaskWorker.this.taskManager.sendTask(subTask);
            }
        });
        ExecReturn rtn = ExecReturn.newSuccAndUptRtn("tot_subtask_num");
        task.setExecReturn(rtn);
    }

    private void createSubTask(Task task) {
        List<Task> listSubTask = this.doCreateSub(task);
        this.saveSubTaskList(listSubTask);
        ExecReturn rtn = ExecReturn.newSuccAndUptRtn("tot_subtask_num");
        this.savaStat(task, rtn, 55);
        this.sendToNext(listSubTask);
    }

    private List<Task> doCreateSub(Task task) {
        List<Task> listSubTask = this.executer.createSubTask(task);
        if (listSubTask != null) {
            task.setTot_subtask_num(listSubTask.size());
        } else {
            task.setTot_subtask_num(0);
        }
        return listSubTask;
    }

    private void saveSubTaskList(List<Task> listSubTask) {
        this.taskManager.batchSave(listSubTask);
    }

    private void sendToNext(List<Task> listSubTask) {
        this.taskManager.sendTask(listSubTask);
    }

    private void doExec(Task task) {
        this.savaStat(task, 20);
        ExecReturn rtn = this.executer.execStep(task);
        this.savaStat(task, rtn, 29);
    }

    private void syncTaskInfo(Task task) {
        this.taskManager.syncTaskInfo(task);
    }

    private void savaStat(Task task, ExecReturn rtn, int newStatus) {
        task.setExecReturn(rtn);
        this.taskManager.savaStat(task, newStatus);
    }

    private void savaStat(Task task, int newStatus) {
        this.taskManager.savaStat(task, newStatus);
    }

    @Override
    public void start() {
    }

    @Override
    public void onComplete(Task task) {
        try {
            this.executer.onComplete(task);
        }
        catch (Exception e) {
            ServiceLogs.errLog((String)this.logtype, (Exception)e, (String)"\u6267\u884c billno[{0}],tasktype[{1}]\u7684onComplete\u65f6\u53d1\u751f\u9519\u8bef:[{3}]", (Object[])new Object[]{task.getBillno(), task.getTask_type(), e.getMessage()});
        }
    }

    @Override
    public TaskExecuter getTaskExecuter() {
        return this.executer;
    }
}

