/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.taskflow.work;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.TaskExecuter;
import com.efuture.taskflow.TaskManager;
import com.efuture.taskflow.TaskWorker;
import com.efuture.taskflow.work.StandardTaskWorker;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="defaultTaskWorkerFactory")
public class TaskWorkerFactory
implements ApplicationContextAware,
InitializingBean {
    ConcurrentHashMap<String, TaskWorker> workerRegistry = new ConcurrentHashMap();
    ApplicationContext applicationContext;

    public TaskWorker getWorker(String taskGroup, String taskType) {
        String key = taskGroup + "-" + taskType;
        return this.workerRegistry.get(key);
    }

    public void registerTaskExecuter(TaskExecuter executer) {
        String key = executer.getTaskGroup() + "-" + executer.getTaskType();
        if (this.workerRegistry.contains(key)) {
            throw new ServiceException("90001", "[{0}]\u6b64\u4efb\u52a1\u5904\u7406\u5bf9\u8c61\u5df2\u7ecf\u6ce8\u518c\uff0c\u4e0d\u80fd\u91cd\u590d\u6ce8\u518c", key, new Object[0]);
        }
        TaskWorker worker = this.getTaskWorker(executer);
        this.workerRegistry.put(key, worker);
    }

    private TaskWorker getTaskWorker(TaskExecuter executer) {
        StandardTaskWorker worker = new StandardTaskWorker(executer, this.getTaskManager());
        worker.start();
        return worker;
    }

    private TaskManager getTaskManager() {
        return TaskComponentFactory.getTaskManager();
    }

    public void afterPropertiesSet() throws Exception {
        ServiceLogs.debuglog((String)"TaskWorkerFactory", (String)"\u5f00\u59cb\u6ce8\u518c\u6267\u884c\u5668", (long)0L);
        Map taskExecuters = this.applicationContext.getBeansOfType(TaskExecuter.class);
        if (Objects.nonNull(taskExecuters)) {
            for (TaskExecuter taskExec : taskExecuters.values()) {
                ServiceLogs.debuglog((String)"TaskWorkerFactory", (String)"\u6ce8\u518c\u6267\u884c\u5668[{0}]-[{1}]", (long)0L, (Object[])new Object[]{taskExec.getTaskGroup(), taskExec.getTaskType()});
                this.registerTaskExecuter(taskExec);
            }
        }
        ServiceLogs.debuglog((String)"TaskWorkerFactory", (String)"\u6ce8\u518c\u6267\u884c\u5668\u5b8c\u6bd5,\u6ce8\u518c[{0}]\u4e2a", (long)0L, (Object[])new Object[]{taskExecuters.size()});
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

