package com.efuture.taskflow.MessageConvert;

import com.efuture.ocp.common.component.BasicComponentService;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.entity.Task;
import org.springframework.core.GenericTypeResolver;
import org.springframework.stereotype.Component;


public interface ConvertMessageToTask<T extends Task> {

    /**
     * 把Message转换为Task
     *
     * @param msg
     * @return
     */
    T convertMessageToTask(Message msg);

    default T convertTask(Task task) {
        return (T) task;
    }

    default Class<T> getTaskClass(){
        return (Class<T>) GenericTypeResolver.resolveTypeArgument(this.getClass(), ConvertMessageToTask.class);
    }


    /**
     * 返回要注册的Message topic
     *
     * @return
     */
    String regTopic();
}
