package com.efuture.taskflow.MessageConvert;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.TaskExecuter;
import com.efuture.taskflow.TaskWorker;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.param.TaskParam;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Component("convertMessageUtils")
public class ConvertMessageUtils implements ApplicationContextAware, InitializingBean {
    ApplicationContext applicationContext;

    ConcurrentHashMap<String, ConvertMessageToTask> convertRegistry = new ConcurrentHashMap<String, ConvertMessageToTask>();

    private DefaultConvertMessageHandle defaultConvertMessageHandle = new DefaultConvertMessageHandle();

    private class DefaultConvertMessageHandle implements ConvertMessageToTask {

        /**
         * 把Message转换为Task
         *
         * @param msg
         * @return
         */
        @Override
        public Task convertMessageToTask(Message msg) {
            JSONObject data = JSONObject.parseObject(msg.getData());
            Task task = JSONObject.toJavaObject(data, Task.class);
            task.setTopic(msg.getTopic());
            task.setExec_count(msg.getRetryCount());
            return task;
        }

        @Override
        public Task convertTask(Task task) {
            return task;
        }

        @Override
        public Class getTaskClass() {
            return Task.class;
        }

        /**
         * 返回要注册的Message topic
         *
         * @return
         */
        @Override
        public String regTopic() {
            return "all";
        }
    }


    public ConvertMessageToTask getConvertMessageHandle(long entId, String topic) {
        if (StringUtils.isEmpty(topic)) {
            topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(entId);
        }
        String defaultMsgConvertHandle = TaskParam.TASK_PUBLIC.TASK_DEFAULT_CONVERT_MESSAGE_HANDLE.getVal(entId);
        ConvertMessageToTask handle = convertRegistry.get(topic);
        if (handle == null) {
            handle = convertRegistry.get(defaultMsgConvertHandle);
        }
        if (handle == null) {
            return defaultConvertMessageHandle;
        } else {
            return handle;
        }
    }

    public Task messageToTask(Message msg) {
        return getConvertMessageHandle(msg.getEnt_id(), msg.getTopic()).convertMessageToTask(msg);
    }

    public Task convertTask(Task task) {
        return getConvertMessageHandle(task.getEnt_id(), task.getTopic()).convertTask(task);
    }

    public void registerConvertMessageHandle(ConvertMessageToTask converter) {
        String topic = converter.regTopic();
        if(StringUtils.isEmpty(topic)){
            topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(0);
        }
        String[] topics = topic.split(",");
        for (int i = 0; i < topics.length; i++) {
            convertRegistry.put(topics[i], converter);
        }
    }

    /**
     * Invoked by a BeanFactory after it has set all bean properties supplied
     * (and satisfied BeanFactoryAware and ApplicationContextAware).
     * <p>This method allows the bean instance to perform initialization only
     * possible when all bean properties have been set and to throw an
     * exception in the event of misconfiguration.
     *
     */
    @Override
    public void afterPropertiesSet() {

        ServiceLogs.debuglog("ConvertMessageUtils", "开始注册消息转换器", 0);
        Map<String, ConvertMessageToTask> convertMessageToTaskMap = this.applicationContext.getBeansOfType(ConvertMessageToTask.class);
        if (Objects.nonNull(convertMessageToTaskMap)) {
            for (ConvertMessageToTask converter : convertMessageToTaskMap.values()) {
                ServiceLogs.debuglog("ConvertMessageUtils", "注册消息转换器[{0}]", 0, converter.regTopic());
                registerConvertMessageHandle(converter);
            }
        }
        ServiceLogs.debuglog("ConvertMessageUtils", "注册消息转换器完毕,注册[{0}]个", 0, convertMessageToTaskMap.size());

    }

    /**
     * Set the ApplicationContext that this object runs in.
     * Normally this call will be used to initialize the object.
     * <p>Invoked after population of normal bean properties but before an init callback such
     * as {@link InitializingBean#afterPropertiesSet()}
     * or a custom init-method. Invoked after {@link ResourceLoaderAware#setResourceLoader},
     * {@link ApplicationEventPublisherAware#setApplicationEventPublisher} and
     * {@link MessageSourceAware}, if applicable.
     *
     * @param applicationContext the ApplicationContext object to be used by this object
     * @throws ApplicationContextException in case of context initialization errors
     * @throws BeansException              if thrown by application context methods
     * @see BeanInitializationException
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
