package com.efuture.taskflow.entity;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.AbstractEntityBean;
import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.taskflow.TaskConstant;
import com.efuture.taskflow.param.TaskParam;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.data.annotation.Transient;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotNull;
import java.util.Date;

public class Task extends AbstractEntityBean implements Cloneable {

    /**
     *
     */
    private static final long serialVersionUID = -1929584351714980822L;


    @Transient
    InterTaskStatus taskStatus = new InterTaskStatus();
    private long ph_key; // 物理主键
    @NotNull(message = "任务单创建时间")
    private Date ph_timestamp; // 时间戳
    @NotBlank(message = "任务单号不能为空")
    private String billno;// 任务单号
    @NotBlank(message = "来源业务单号不能为空")
    private String src_billno;// 来源单据号
    private String others_billno;// 渠道单号
    @NotBlank(message = "任务类型不能为空")
    private String task_type;// 任务类型
    private String task_group;// 任务分组
    private String parent_billno;// 父任务编号
    @NotBlank(message = "是否是主任务不能为空")
    private String isMainTask = "N";// 是否是主任务
    private int tot_step;// 共几步
    private int step;// 第几步
    private int task_status = TaskConstant.TASK_STATUS.CREATE;
    private int tot_subtask_num = 0;// 子任务数
    private int success_subtask_num = 0;// 执行成功的子任务数
    private int error_subtask_num = 0;// 执行错误的子任务数
    // private int cur_exec_step = 0;
    // 执行次数
    private int exec_count = 0;
    private long Last_exec_date;
    private String last_exec_error;
    private String last_exec_errorCode;//最后一次错误的code  errGroup:errCode
    private String last_exec_errorGroup;//errGroup
    // 存储位置 默认为MQ,从数据库中查询的时候，需要给此字段复制为存储的表名
    @Transient
    private String src_table = "MQ";
    private String topic;
    @Transient
    private int run_mode = TaskConstant.RUN_MODE.NORMAL_RUN; //运行方式
    @Transient
    private ExecReturn execReturn;
    @Transient
    private JSONObject data;

    public Task() {
        super();
    }

    public Task(long entId, String billno, String src_billno, String task_type, String task_group, int tot_step, int step,
                Object data) {
        super();
        this.ent_id = entId;
        this.billno = billno;
        this.src_billno = src_billno;
        this.task_type = task_type;
        this.task_group = task_group;
        this.tot_step = tot_step;
        this.step = step;
        this.data = (JSONObject) JSONObject.toJSON(data);
        this.setPh_timestamp(new Date());
        this.setTopic(TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(entId));
    }

    @Override
    public String toString() {
        return this.billno;
    }

    public InterTaskStatus getTaskStatus() {
        taskStatus.setTask_status(task_status);
        // taskStatus.setCur_exec_step(cur_exec_step);
        return taskStatus;
    }

    public void setTaskStatus(InterTaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Task newInstance() {
        return new Task();
    }

    public Task fastCopy(Task task, String newBillno, String task_type, int curStep, Object data) {
        Task subTask = task.newInstance();
        subTask.setEnt_id(task.getEnt_id());
        subTask.setBillno(newBillno);
        subTask.setParent_billno(task.getBillno());
        subTask.setPh_timestamp(new Date());
        subTask.setTask_status(TaskConstant.TASK_STATUS.CREATE);
        subTask.setTask_group(task.getTask_group());
        subTask.setTask_type(task_type);
        subTask.setData(data);
        subTask.setSrc_billno(task.getSrc_billno());
        subTask.setOthers_billno(task.getOthers_billno());
        subTask.setTot_step(task.getTot_step());
        subTask.setStep(curStep);
        if (subTask.getTot_step() <= subTask.getStep()) {
            subTask.setIsMainTask("L");
        }
        return subTask;
    }

    @Override
    public Task clone() {
        try {
            return (Task) super.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 是否还未开始
     *
     * @return
     */
    public boolean isNotStart() {
        return this.getTask_status() < TaskConstant.TASK_STATUS.EXEC_START;
    }

    /**
     * 主过程是否已经执行完毕
     *
     * @return
     */
    public boolean isExecComplete() {
        return this.getTask_status() >= TaskConstant.TASK_STATUS.EXEC_COMPLETE;
    }

    public boolean isExecing() {
        return this.getTask_status() < TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE;
    }

    /**
     * 此任务本体是否执行完毕
     *
     * @return
     */
    public boolean isThisComplete() {
        return this.getTask_status() >= TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE;
    }

    /**
     * 此任务是否在等待子任务完成
     *
     * @return
     */
    public boolean isWaitSubComplete() {
        return this.getTask_status() == TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE;
    }

    /**
     * 创建子任务是否完成
     *
     * @return
     */
    public boolean isCreateSubComplete() {
        return this.getTask_status() >= TaskConstant.TASK_STATUS.CREATE_SUB_COMPLETE;
    }

    /**
     * 任务是否已经停止，完成和出错的，都是停止的
     *
     * @return
     */
    public boolean isStoped() {
        return this.getTask_status() >= TaskConstant.TASK_STATUS.ALL_COMPLETE;
    }

    public boolean hasParent() {
        return !StringUtils.isEmpty(this.parent_billno);
    }

    public boolean isAllSubCompleted() {
        if (this.tot_subtask_num <= this.success_subtask_num + this.error_subtask_num) {
            return true;
        } else {
            return false;
        }

    }

    public boolean hasSub() {
        return this.tot_subtask_num > 0;
    }

    public String getLockKey() {
        return "lock:" + this.getBillno();
    }

    public String getStatusKey() {
        return "status:" + this.getBillno();
    }

    public String getParentStatusKey() {
        return "status:" + this.getParent_billno();
    }

    public String getStatusValue() {
        return JSONObject.toJSONString(this.getTaskStatus());
    }

    public InterTaskStatus convertToTaskStatus(String statusValue) {
        return JSONObject.parseObject(statusValue, InterTaskStatus.class);
//		return JSONObject.toJavaObject((JSONObject) JSONObject.parse(statusValue),
//				InterTaskStatus.class);
    }

    /**
     * 1.子任务，只有自身的状态变更，此状态变更必须保持实时的,此状态变更后，必须马上更新到缓存，然后异步等待5秒后统一入库
     * 2.非子任务，状态是定时统计的，因此，更新频率不一样，定时统计，每次统计后，都会保存到数据库，这个数据可以和任务主信息放在一起
     */
    public boolean setStatusValue(String statusValue) {

        if (statusValue == null) {
            throw new ServiceException("600001", "状态信息不能为空");
        }

        InterTaskStatus newstatus = convertToTaskStatus(statusValue);

        int oldstatus = this.getTask_status();
        // int oldCurStep = this.getCur_exec_step();
        int newStatus = newstatus.getTask_status();
        // int newCurStep = newstatus.getCur_exec_step();
        boolean ibChanged = false;
        if (newStatus > oldstatus) {
            this.setTask_status(newStatus);
            ibChanged = true;
        }

        return ibChanged;
    }

    public String getDataKey() {
        return "data:" + this.getBillno();
    }
    // public TaskStatus getTaskStatus() {
    // return taskStatus;
    // }
    //
    // public void setTaskStatus(TaskStatus taskStatus) {
    // this.taskStatus = taskStatus;
    // }
    //
    // private TaskStatus taskStatus;

    public String getParent_billno() {
        return parent_billno;
    }

    public void setParent_billno(String parent_billno) {
        this.parent_billno = parent_billno;
    }

    public ExecReturn getExecReturn() {
        return execReturn;
    }

    public void setExecReturn(ExecReturn execReturn) {
        this.execReturn = execReturn;
    }

    public JSONObject getData() {
        return data;
    }

    public void setData(Object data) {
        if (data instanceof String) {
            //String json= StringEscapeUtils.unescapeHtml((String) data);
            //Map t = JSONObject.parseObject(data.toString(),HashMap.class);
            this.data = (JSONObject) JSONObject.parse((String) data);
        } else {
            this.data = (JSONObject) JSONObject.toJSON(data);
        }

    }

    public long getPh_key() {
        return ph_key;
    }

    public void setPh_key(long ph_key) {
        this.ph_key = ph_key;
    }

    public Date getPh_timestamp() {
        if (ph_timestamp == null) {
            ph_timestamp = new Date();
        }
        return ph_timestamp;
    }

    public void setPh_timestamp(Date ph_timestamp) {
        this.ph_timestamp = ph_timestamp;
    }

    public String getBillno() {
        return billno;
    }

    public void setBillno(String billno) {
        this.billno = billno;
    }

    public String getOthers_billno() {
        return others_billno;
    }

    public void setOthers_billno(String channel_billno) {
        this.others_billno = channel_billno;
    }

    public String getTask_type() {
        return task_type;
    }

    public void setTask_type(String task_type) {
        this.task_type = task_type;
    }

    public int getTot_subtask_num() {
        return this.tot_subtask_num;
    }

    public void setTot_subtask_num(int tot_subtask_num) {
        this.tot_subtask_num = tot_subtask_num;
    }

    public int getError_subtask_num() {
        return this.error_subtask_num;
    }

    public void setError_subtask_num(int error_subtask_num) {
        this.error_subtask_num = error_subtask_num;
    }

    public int getTask_status() {
        return this.task_status;
    }

    public void setTask_status(int task_status) {
        this.task_status = task_status;
    }

    public String getIsMainTask() {
        return isMainTask;
    }

    public void setIsMainTask(String isMainTask) {
        this.isMainTask = isMainTask;
    }

    public String getSrc_billno() {
        return src_billno;
    }

    public void setSrc_billno(String src_billno) {
        this.src_billno = src_billno;
    }

    public int getSuccess_subtask_num() {
        return this.success_subtask_num;
    }

    public void setSuccess_subtask_num(int success_subtask_num) {
        this.success_subtask_num = success_subtask_num;
    }

    public int getTot_step() {
        return tot_step;
    }

    public void setTot_step(int tot_step) {
        this.tot_step = tot_step;
    }

    public int getStep() {
        return step;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public String getTask_group() {
        return task_group;
    }

    public void setTask_group(String task_group) {
        this.task_group = task_group;
    }

    public int getExec_count() {
        return this.exec_count;
    }

    public void setExec_count(int exec_count) {
        this.exec_count = exec_count;
    }

    public String getLast_exec_error() {
        return this.last_exec_error;
    }

    public void setLast_exec_error(String last_exec_error) {
        this.last_exec_error = last_exec_error;
    }

    public long getLast_exec_date() {
        return this.Last_exec_date;
    }

    public void setLast_exec_date(Date lastDate) {
        this.Last_exec_date = lastDate.getTime() / 1000;
    }

    public void setLast_exec_date(long lastDate) {
        this.Last_exec_date = lastDate;
    }
    // public int getCur_exec_step() {
    // return this.cur_exec_step;
    // }
    //
    // public void setCur_exec_step(int cur_exec_step) {
    //
    // this.cur_exec_step = cur_exec_step;
    // }

    public void setSubTaskStatusInfo(SubTaskStatusInfo subTaskInfo) {
        this.success_subtask_num = subTaskInfo.getSuccess_subtask_num();
        this.error_subtask_num = subTaskInfo.getError_subtask_num();
    }


    public String getSrc_table() {
        return src_table;
    }

    public void setSrc_table(String src_table) {
        this.src_table = src_table;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }


    public int getRun_mode() {
        return run_mode;
    }

    public void setRun_mode(int run_mode) {
        this.run_mode = run_mode;
    }

    public String getLast_exec_errorCode() {
        return last_exec_errorCode;
    }

    public void setLast_exec_errorCode(String last_exec_errorCode) {
        this.last_exec_errorCode = last_exec_errorCode;
    }

    public void setLast_exec_errorCode(String errorGroup, String errorCode) {
        this.last_exec_errorGroup = errorGroup;
        this.last_exec_errorCode = errorCode;
    }

    public String getLast_exec_errorGroup() {
        return last_exec_errorGroup;
    }

    public void setLast_exec_errorGroup(String last_exec_errorGroup) {
        this.last_exec_errorGroup = last_exec_errorGroup;
    }
}
