package com.efuture.taskflow.exception;

import com.efuture.ocp.common.exception.ServiceException;

public enum TaskExceptionCode {
    NOT_HANDLE_ERROR(ServiceException.ERR_GROUP.UNKNOWN, "80000", "未知错误，错误信息为:[{0}]"),
    GET_TASKDATA_ERROR(ServiceException.ERR_GROUP.DATA, "70007", "未能获取[{0}]的任务数据,详细原因:[{1}]"),
    WRONG_CHECK_TYPE(ServiceException.ERR_GROUP.DATA, "70006", "错误的检查类型[{0}]"),
    NOT_FIND_TASKDATA(ServiceException.ERR_GROUP.DATA, "70005", "没有找到任务[{0}]数据信息"),
    NO_TASKINFO(ServiceException.ERR_GROUP.DATA, "70000", "没有找到任务[{0}]的信息"),
    NO_WORKER(ServiceException.ERR_GROUP.DATA, "70001", "没有找到任务类型[{0}]对应的执行器"),
    GET_UPT_INFO_ERROR(ServiceException.ERR_GROUP.DATA, "70003", "获取更新信息时错误，错误信息为:{0}"),
    GET_OBJ_COLDATA(ServiceException.ERR_GROUP.DATA, "70004", "获取任务[{0}]的字段[{1}]内容错误，错误信息为[{2}]");
    String group;
    String code;
    String msgTemplate;

    TaskExceptionCode(String group, String code, String msgTemplate) {
        this.group = group;
        this.code = code;
        this.msgTemplate = msgTemplate;
    }

    public String getCode() {
        return code;
    }

    public String getMsgTemplate() {
        return msgTemplate;
    }

    public String getGroup() {
        return group;
    }

    public void throwThisException(Object... args) {
        throw new ServiceException(this.getGroup(), this.getCode(), this.getMsgTemplate(), args);
    }
}
