package com.efuture.taskflow.monitoring;

import com.efuture.ocp.common.util.DateUtils;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class TaskMonitorService {

    /**
     * 查询当前任务概览
     *
     * @param startDay
     * @param endDay
     * @return
     */
    public TaskSummary getTaskSummary(Date startDay, Date endDay) {
        UnfinishedTaskSummary unfinishedTaskSummary = UnfinishedTaskSummary.getTaskSummary();
        FinishedTaskSummary finishedTaskSummary = FinishedTaskSummary.getTaskSummary(startDay, DateUtils.addDays(endDay, 1));

        return new TaskSummary(unfinishedTaskSummary, finishedTaskSummary);
    }
}
