package com.efuture.taskflow.repository;

import com.alibaba.fastjson.JSONObject;
import com.efuture.taskflow.entity.SubTaskStatusInfo;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.entity.TaskErrorInfo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface TaskRepository {

    Task save(Task task);

    void updateTask(Task task, String uptCols);

    void batchSave(List<Task> taskList);

    Task checkTaskExist(Task task);

    Task findTaskByBillno(long entId, String billNO);

    void logError(Task Task, String message);

    Task findTaskById(long ent_id, long ph_key);

    void moveTaskToSuccess(Task task);

    void moveTaskToWaitSub(Task task);

    void clearTaskErrorLog(Task task);

    void insExecCompleteLog(Task task);

    void moveTaskToErrorList(Task task);

    boolean checkTaskIsExecComplete(Task task);

    TaskErrorInfo queryTaskErrorInfo(long ph_key);


    void delExecCompleteLog(Task task);

    SubTaskStatusInfo querySubTaskStatus(long ent_id, String billno);

//	public List<Task> queryNotCompletedTaskInfo(int overMins);

    void updateSubTaskStatus(String billno, int stop);

    List<Task> querySubTaskNotLast(String billno);

    List<Task> queryUnfinishedTaskInfo(Date startDate, Date endDate, long lastPhkey);

    List<Task> queryWaitSubTaskInfo(Date startDate, Date endDate, long lastPhkey);


    List<Task> queryTaskList(JSONObject condition);
    /**
     * 查询错误分组的错误任务条数
     *
     * @param startDay
     * @param endDay
     * @return
     */
    Map<String, Long> queryFailedTaskErrorGroup(Date startDay, Date endDay);

    /**
     * 查询成功的条数
     *
     * @param startDay
     * @param endDay
     * @return
     */
    long querySucceedTaskCount(Date startDay, Date endDay);
}
