package com.efuture.taskflow.service;

import com.efuture.ocp.common.exception.ServiceException;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.TaskWorker;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.exception.TaskExceptionCode;
import org.springframework.stereotype.Component;

/**
 * 任务启动器 1.根据程序的注册分发消息
 * <p>
 * TaskGroup 表示是什么业务 比如活动发布 TaskType 表示是什么步骤比如那个渠道发布活动的哪个步骤
 *
 * @author zhouwd
 */
@Component("defaultTaskMessageConsumer")
public class TaskMessageConsumer {

    public TaskMessageConsumer() {
        super();
    }

    // 分发消息
    public int consume(Task task) {
        return runTask(task);
    }

    public int runTask(Task task) {
        TaskWorker taskWorker = null;
        try {
            taskWorker = getTaskWorker(task);
        } catch (Exception e) {
            TaskComponentFactory.getTaskManager().handleError(task, e);
            return -1;
        }
        taskWorker.receiveTask(task);
        return 0;
    }

    private TaskWorker getTaskWorker(Task task) {
        TaskWorker worker = TaskComponentFactory.getTaskWorkerFactory().getWorker(task.getTask_group(),
                task.getTask_type());
        if (worker == null) {
            throw new ServiceException(TaskExceptionCode.NO_WORKER.getCode(),
                    TaskExceptionCode.NO_WORKER.getMsgTemplate(), task.getTask_group() + "-" + task.getTask_type());
        }
        return worker;
    }


}
