package com.efuture.taskflow.taskdata;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.common.util.SpringBeanFactory;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.param.TaskParam;
import com.efuture.taskflow.utils.Utils;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

@Component("defaultTaskDataQuery")
public class TaskDataQueryByTaskExecuter implements TaskDataQuery {

    String logtype = "TaskDataQuery";

    /**
     * 1.先从数据库读取任务信息，数据库灵活性最高
     * 2.再从MQ中读取数据
     * 3.再调用程序获取数据
     * @param task
     * @return
     */
    @Override
    public Object getTaskData(Task task) {
        if (task.getData() != null) {
            return task.getData();
        }
        Object data = TaskComponentFactory.getTaskDataRepository().query(task.getEnt_id(), task.getPh_key());
        if (data != null) {
            return data;
        } else {
            ServiceLogs.debuglog(logtype, "未能从数据库中获取任务[{0}]的任务数据", 0, task.getPh_key());
        }

         data = getFromMq(task);
        if (data != null) {
            return data;
        }

        return TaskComponentFactory.getTaskWorkerFactory().getWorker(task.getTask_group(), task.getTask_type())
                .getTaskExecuter().getTaskDataByTaskInfo(task);

    }

    private Object getFromMq(Task task) {
        DefaultMQProducer mqp = null;
        try {
            mqp = SpringBeanFactory.getContext().getBean(DefaultMQProducer.class);
            if (mqp == null) {
                return null;
            }
        } catch (Exception e) {
            return null;
        }

        String topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(0);
        String key = topic + "-" + task.getBillno();

        long begin = task.getPh_timestamp().getTime() - 1000 * 60 * 60;
        long end = (new Date()).getTime();
        try {
            QueryResult qr = mqp.queryMessage(TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(0), key, 10, begin, end);
            List<MessageExt> messageList = qr.getMessageList();
            if (messageList == null || messageList.size() == 0) {
                ServiceLogs.debuglog(logtype, "未能从MQ获取任务[{0}]的任务数据", 0, key);
                return null;
            }
            if (messageList.size() > 1) {
                ServiceLogs.debuglog(logtype, "从MQ获取任务[{0}]的任务数据存在多个相同key的任务数据存在,将返回第一行数据", 0, key);
            }
            MessageExt msgExt = messageList.get(0);
            JSONObject jobj = (JSONObject) JSONObject.parse(msgExt.getBody());
            Message msg = JSONObject.toJavaObject(jobj, Message.class);
            Task mqTask = Utils.convertMessageToTask(msg);
            return mqTask.getData();
        } catch (MQClientException e) {
            ServiceLogs.errLog(logtype, e, "从MQ获取任务[{0}]的任务数据错误，错误信息为[{1}]", key, e.getMessage());
            return null;
        } catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

}
