package com.efuture.taskflow.taskdata;

import com.efuture.omd.storage.FStorageOperations;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.entity.TaskDataBean;
import com.efuture.taskflow.utils.DataBaseConfigUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component("taskDataRepositoryByDb")
public class TaskDataRepositoryImpl implements TaskDataRepository {


    @Override
    @Transactional
    public void save(Task task) {
        TaskDataBean dataBean = new TaskDataBean(task);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        Criteria criteria = Criteria.where("ph_key").is(task.getPh_key()).and("ent_id").is(task.getEnt_id());
        Query queryByKey = new Query(criteria);
        String tableName = DataBaseConfigUtils.getTableName(DataBaseConfigUtils.TASK_DATA_LIST);
        fso.delete(queryByKey, tableName);
        fso.insert(dataBean, tableName);
    }


    @Override
    public String query(long entId, long phKey) {
        Criteria criteria = Criteria.where("ph_key").is(phKey).and("ent_id").is(entId);
        Query queryByKey = new Query(criteria);
        FStorageOperations fso = DataBaseConfigUtils.getStorageOperations();
        TaskDataBean taskdata = fso.selectOne(queryByKey, TaskDataBean.class, DataBaseConfigUtils.getTableName(DataBaseConfigUtils.TASK_DATA_LIST));
        if (taskdata == null) {
            return null;
        } else {
            return taskdata.getTaskdata();
        }
    }
}
