package com.efuture.taskflow.taskmanager;

import org.springframework.context.ApplicationEvent;

import com.efuture.ocp.common.util.UniqueID;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.param.TaskParam;

public class TaskStatusChangeEvent extends ApplicationEvent {

	/**
	 * 
	 */
	public interface EVENT_TYPE {
		int curTaskChanged = 0;
		int subTaskCompleted = 1;
	}

	private static final long serialVersionUID = 3157526208063842252L;
	Task task;
	int oldStatus;
	int eventType;
	boolean saveImmediately = true;
	long eventLogKey;

	public Task getTask() {
		return task;
	}

	public int getOldStatus() {
		return oldStatus;
	}

	public boolean isSaveImmediately() {
		return saveImmediately;
	}

	public TaskStatusChangeEvent(Task task, int oldStatus) {
		super(task);
		this.task = task;
		this.oldStatus = oldStatus;
		this.eventLogKey = UniqueID.getUniqueID();
		if (task.getExecReturn() != null && task.getExecReturn().getNeedUpdateCols() != null) {
			if (TaskParam.TASK_PUBLIC.ASYNC_SAVE.getVal(0).equalsIgnoreCase("Y")) {
				this.saveImmediately = false;
			} else {
				this.saveImmediately = true;
			}
		} else {
			this.saveImmediately = true;
		}

	}

}
