package com.efuture.taskflow.taskmanager;

import com.efuture.taskflow.entity.Task;

public interface TaskStatusManager {

	void taskStatusChanged(Task task, int newStatus);

	void updateTask(Task task, int oldStatus);

	Task syncTaskStatus(Task task);

	void faildown(Task task, int maxExecNum);

	void refreshTaskStatus(Task task);

	void refreshTaskError(Task task, String errMsg);

	void clearCachedStatus(Task task);

	void stop(Task task);

}
