package com.efuture.taskflow;

import com.efuture.taskflow.entity.ExecReturn;
import com.efuture.taskflow.entity.Task;

import java.util.List;

public interface TaskExecuter {
	/**
	 * 执行本步骤的业务逻辑
	 *
	 * @param task
	 * @return
	 */
	ExecReturn execStep(Task task);

	/**
	 * 重新查询任务的任务数据时，会使用此接口，如果返回空，则默认数据不能重新生成，只能从最开始重新开始
	 * @param task
	 * @return
	 */
	Object getTaskDataByTaskInfo(Task task);
	/**
	 * 创建子任务
	 *
	 * @param task
	 * @return
	 */
	List<Task> createSubTask(Task task);

	/**
	 * 从主任务创建一个子任务
	 *
	 * @param task
	 * @param newBillno
	 * @param data
	 * @return
	 */
	default Task newSubTask(Task task, String newBillno, Object data) {
		// 从数据创建一个新的任务
		return task.fastCopy(task, newBillno, getNextTaskType(), task.getStep() + 1, data);

	}

	/**
	 * 定义 任务类型
	 *
	 * @return
	 */
	String getTaskType();

	/**
	 * 定义下一步的任务类型
	 *
	 * @return
	 */
	String getNextTaskType();

	/**
	 * 定义任务分组
	 *
	 * @return
	 */
	String getTaskGroup();

	/**
	 * 本任务完成后的回调方法，指全部子任务完成时才会调用
	 *
	 * @param task
	 */
	void onComplete(Task task);

	/**
	 * 创建完子任务后的回调方法
	 */
	default void onCreateSubComplete(Task task){

	}

	/**
	 * 本次执行完后的回调方法
	 * @param task
	 */
	default void onExecComplete(Task task){

	}
}
