package com.efuture.taskflow.monitoring;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.util.CacheUtils;
import com.efuture.taskflow.TaskConstant;
import com.efuture.taskflow.entity.Task;

import java.util.Date;

public class UnfinishedTaskSummary
{
    Date summaryDate = new Date();
    //正在运行的数据 未完成+等待的
    int runingNum;

    //正在重试的任务数量 未完成的并且执行次数大于1的数量
    int retryingNum;

    //正在等待子任务完成的数量 等待的
    int waitingNum;

    public static UnfinishedTaskSummary getTaskSummary()
    {
        String str = CacheUtils.getCacheUtils().getData(getCacheKey()).toString();
        UnfinishedTaskSummary summary = JSONObject.parseObject(str, UnfinishedTaskSummary.class);
        return summary;
    }

    public static String getCacheKey()
    {
        return "$TASK_SUMMARY_CACHE$";
    }

    public void possessTask(Task task)
    {
        if (task.getTask_status() == TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE) {
            waitingNum++;
        }
        else if (task.getTask_status() < TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE) {
            if (task.getExec_count() >= 1) {
                retryingNum++;
            }
            else {
                runingNum++;
            }
        }
        else if (task.getTask_status() >= TaskConstant.TASK_STATUS.QUIT) {
            retryingNum++;
        }
        else if (task.getTask_status() > TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE) {
            //TODO 是否处理？
        }
    }

    /**
     * 保存到缓存中
     */
    public void save()
    {
        setValToCached(getCacheKey(), JSONObject.toJSONString(this), 30);
    }

    private void setValToCached(String key, String val, int mins)
    {
        CacheUtils.getCacheUtils().putData(key, val, mins * CacheUtils.CacheTimeOut.Min);
    }

    public Date getSummaryDate()
    {
        return summaryDate;
    }

    public void setSummaryDate(Date summaryDate)
    {
        this.summaryDate = summaryDate;
    }

    public int getRuningNum()
    {
        return runingNum;
    }

    public void setRuningNum(int runingNum)
    {
        this.runingNum = runingNum;
    }

    public int getRetryingNum()
    {
        return retryingNum;
    }

    public void setRetryingNum(int retryingNum)
    {
        this.retryingNum = retryingNum;
    }

    public int getWaitingNum()
    {
        return waitingNum;
    }

    public void setWaitingNum(int waitingNum)
    {
        this.waitingNum = waitingNum;
    }
}
