package com.efuture.taskflow.param;

import com.efuture.ocp.common.sysparam.SystemParam;
import org.springframework.stereotype.Component;

@Component
public class TaskParam
{

    public TaskParam()
    {
        super();
        printParam();
    }

    private void printParam()
    {
        TASK_PUBLIC[] param = TASK_PUBLIC.values();
        TableList t = new TableList("配置名", "说明", "默认值");

        for (TASK_PUBLIC p : param) {
            String key = p.getPreParaStr() + "." + p.key;
            t.addRow(key, p.getDesc(), p.defaultVals);
        }

        t.print();
        //		System.out.println(at.render());
    }

    public enum TASK_PUBLIC implements SystemParam {
        TASK_DEFAULT_CONVERT_MESSAGE_HANDLE("defaultMsgConvertHandle", "默认消息转换器名称", "defaultMsgConvertHandle"),
        TASK_WORKER_FACTORY("taskworkerfactory", "taskworkerfactory的实现对象", "defaultTaskWorkerFactory"),
        TASK_MESSAGE_CONSUMER("taskmessageconsumer", "TaskMessageConsumer的实现对象", "defaultTaskMessageConsumer"),
        TASK_DATA_QUERY("taskdataquery", "任务数据查询的实现对象", "defaultTaskDataQuery"),
        TASK_DATA_REPO("taskdatarepo", "任务数据存储的实现对象", "taskDataRepositoryByDb"),
        TASK_STATUS_MANAGER("taskstatusmanager", "taskstatusmanager的实现对象", "defaultTaskStatusManager"),
        TASK_MANAGER("taskmanager", "taskmanager的实现对象", "defaultTaskManager"),
        TASK_REPOSITORY("taskrepository", "TaskRepository的实现对象", "taskRepositoryBydb"),
        TASK_QUEUESERVICE("taskqueueservice", "taskqueueservice的实现对象", "taskQueueServicebymq"),
        MAX_RETRY_COUNT("max_retry_count", "最大重试次数", "20"),
        MAX_CHECK_COUNT("max_check_count", "任务检查次数", "10"),
        ASYNC_SAVE("async_save", "异步存盘", "Y"),
        START_TIMEOUT_MINS("max_start_timeout", "任务开始超时时间，默认20分钟。单位：分钟。如果大于此参数还未开始的，则强制启动，如果不能启动则标记需要人工处理", "20"),
        TASK_TIMEOUT_HOURS("max_timeout_hours", "任务执行超时时间，超过此时间则默认为失败了,默认48小时", "48"),
        THIS_TASK_TOPIC("task_topic", "任务管理的MQ主题名称", "TASK_MESSAGE"),
        TABLE_PRE_STR("table_pre_str", "任务表前缀", ""),
        TABLE_POST_STR("table_post_str", "任务表后缀", ""),
        TASK_EXT_COLS("ext.cols", "扩展字段存储", "");
        String key;
        String desc;
        String defaultVals;

        TASK_PUBLIC(String key, String desc, String defaultVals)
        {
            this.key = key;
            this.desc = desc;
            this.defaultVals = defaultVals;
        }

        @Override
        public String getKey()
        {
            return key;
        }

        @Override
        public String getDesc()
        {
            return desc;
        }

        @Override
        public String getPreParaStr()
        {
            return "efuture.task.flow";
        }

        @Override
        public String getDefaultVal()
        {
            return defaultVals;
        }
    }
}
