package com.efuture.taskflow.queue;

import java.util.List;

import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.taskcore.service.TaskProducer;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.param.TaskParam;

@Component("taskQueueServicebymq")
public class TaskQueueServiceImpl implements TaskQueueService {

	@Override
	public int product(Task task) {
		String topic = TaskParam.TASK_PUBLIC.THIS_TASK_TOPIC.getVal(task.getEnt_id());
		String event = "SEND";
		TaskProducer.produce(task.getEnt_id(), topic, event, task.getBillno(), (JSONObject) JSONObject.toJSON(task));
		return 0;
	}

	@Override
	public int batchProduct(List<Task> Listtask) {
		for (Task task : Listtask) {
			product(task);
		}
		return 0;
	}

}
