package com.efuture.taskflow.service;

import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.starter.core.RocketMQListener;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.utils.Utils;

public class DefaultTaskListener implements RocketMQListener<MessageExt> {

	@Override
	public void onMessage(MessageExt msgExt) throws Exception {
		JSONObject jobj = (JSONObject) JSONObject.parse(msgExt.getBody());
		Message msg = JSONObject.toJavaObject(jobj, Message.class);
		long stime = System.currentTimeMillis();
		ServiceLogs.logConsumeMqStart(msg.getTopic(), msg.getKeyvalue(), msgExt.getMsgId());
		msg.setRetryCount(msgExt.getReconsumeTimes());

		TaskComponentFactory.getTaskMessageConsumer().consume(Utils.convertMessageToTask(msg));
		ServiceLogs.logConsumeMqSuccess(msg.getTopic(), msg.getKeyvalue(), msg.getStatus(), stime);
	}

}
