package com.efuture.taskflow.service;

import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.TaskConstant;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.exception.TaskExceptionCode;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TaskService {

    public int run(Task task) {
        return run(task, TaskConstant.RUN_MODE.NORMAL_RUN);
    }

    /**
     * //停止任务
     *
     * @param billNo
     * @return
     */
    public int stop(long entId, String billNo) {
        Task task = TaskComponentFactory.getTaskRepository().findTaskByBillno(entId, billNo);
        if (task == null) {
            TaskExceptionCode.NO_TASKINFO.throwThisException(billNo);
        }
        TaskComponentFactory.getTaskStatusManager().stop(task);
        return 0;
    }


    //@Transactional
    public int run(Task task, int runMode) {
        task.setRun_mode(runMode);
        if (task.getData() == null) {
            Object data = TaskComponentFactory.getTaskDataQuery().getTaskData(task);
            if (data == null) {
                TaskExceptionCode.NOT_FIND_TASKDATA.throwThisException(task.getBillno());
            }
            task.setData(data);
        }
        if (runMode == TaskConstant.RUN_MODE.FORCE_RETRY) {
            // 删除成功执行生成的日志数据
            TaskComponentFactory.getTaskRepository().delExecCompleteLog(task);
            // 清理缓存中的状态数据
            TaskComponentFactory.getTaskStatusManager().clearCachedStatus(task);
        }
//        TaskComponentFactory.getTaskWorkerFactory().getWorker(task.getTask_group(), task.getTask_type()).receiveTask(task);
        return TaskComponentFactory.getTaskMessageConsumer().consume(task);
    }
}
