package com.efuture.taskflow.service;

import com.alibaba.fastjson.JSONObject;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.entity.ServiceSession;
import com.efuture.ocp.common.language.ResponseCode;
import com.efuture.ocp.taskcore.message.Message;
import com.efuture.taskflow.TaskComponentFactory;
import com.efuture.taskflow.TaskConstant;
import com.efuture.taskflow.entity.Task;
import com.efuture.taskflow.job.TaskJob;
import com.efuture.taskflow.monitoring.TaskMonitorService;
import com.efuture.taskflow.monitoring.TaskSummary;
import com.efuture.taskflow.repository.TaskRepository;
import com.efuture.taskflow.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service("ocp.task.service")
public class TaskServiceControl {


    @Autowired
    TaskService service;


    @Autowired
    TaskJob taskJob;
    @Autowired
    TaskMonitorService taskMonitorSrv;

    public ServiceResponse checkTaskStatus(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        String taskBillno = jsonparam.getString("billno");
        return ServiceResponse.buildSuccess(taskJob.checkTaskStatus(session.getEnt_id(), taskBillno));
    }

    public ServiceResponse stop(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        String taskBillno = jsonparam.getString("billno");
        service.stop(session.getEnt_id(), taskBillno);
        return ServiceResponse.buildSuccess("OK");

    }

    public ServiceResponse retry(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        Task task = JSONObject.toJavaObject(jsonparam, Task.class);
        task.setTask_status(TaskConstant.TASK_STATUS.CREATE);//by zhouwd 2020-8-13？？
        service.run(task, task.getRun_mode());
        return ServiceResponse.buildSuccess("OK");
    }

    public ServiceResponse retryByBillno(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        String billno = jsonparam.getString("billno");
        if (billno == null) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.SPECDATA_IS_EMPTY, "billno");
        }
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        Task task = repository.findTaskByBillno(session.getEnt_id(), billno);
        task.setTask_status(TaskConstant.TASK_STATUS.CREATE);
        task.setRun_mode(TaskConstant.RUN_MODE.FORCE_RETRY);
        service.run(task, task.getRun_mode());
        return ServiceResponse.buildSuccess("OK");
    }

    public ServiceResponse queryUnfinishedTaskInfo(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        Date startDate = jsonparam.getDate("start_date");
        Date endDate = jsonparam.getDate("end_date");
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess(repository.queryUnfinishedTaskInfo(startDate, endDate, 0));
    }

    public ServiceResponse queryWaitSubTaskInfo(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        Date startDate = jsonparam.getDate("start_date");
        Date endDate = jsonparam.getDate("end_date");
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess(repository.queryWaitSubTaskInfo(startDate, endDate, 0));
    }


    public ServiceResponse queryTaskList(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        List<Task> rtn = repository.queryTaskList(jsonparam);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("tasklist", rtn);
        return ServiceResponse.buildSuccess(rtnJson);
    }

    public ServiceResponse queryTaskSummary(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }

        Date startDay = jsonparam.getDate("start_day");
        Date endDay = jsonparam.getDate("end_day");
        TaskSummary summary = taskMonitorSrv.getTaskSummary(startDay, endDay);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("summary", summary);
        return ServiceResponse.buildSuccess(summary);
    }

    public ServiceResponse findTaskByBillno(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        String billno = jsonparam.getString("billno");
        TaskRepository repository = TaskComponentFactory.getTaskRepository();
        return ServiceResponse.buildSuccess(repository.findTaskByBillno(session.getEnt_id(), billno));
    }

    public ServiceResponse testMsg(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        Message msg = JSONObject.toJavaObject(jsonparam, Message.class);
        Task task = Utils.convertMessageToTask(msg);
        service.run(task);
        return ServiceResponse.buildSuccess("OK");

    }

    public ServiceResponse testTask(ServiceSession session, JSONObject jsonparam) {
        if (null == jsonparam) {
            return ServiceResponse.buildFailure(session, ResponseCode.Exception.PARAM_IS_EMPTY);
        }
        Task task = (Task) JSONObject.toJavaObject(jsonparam, Utils.getTaskClass((session.getEnt_id())));
        service.run(task);
        return ServiceResponse.buildSuccess("OK");

    }
}
