package com.efuture.taskflow.work;

import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.rest.ServiceLogs;
import com.efuture.taskflow.*;
import com.efuture.taskflow.entity.ExecReturn;
import com.efuture.taskflow.entity.Task;

import java.util.List;

public class StandardTaskWorker implements TaskWorker {

    String logtype = "StandardTaskWorker";

    TaskExecuter executer;
    TaskManager taskManager;
    // int stepNum = 1;

    public StandardTaskWorker(TaskExecuter executer, TaskManager taskManager) {
        super();
        this.executer = executer;
        this.taskManager = taskManager;
    }

    // int getStepNum() {
    // return stepNum;
    // }

    // @Override
    // public String getNextTopic() {
    //// return nextTopic;
    // }

    @DLock(key = "#args[0].getLockKey()")
    @Override
    public int receiveTask(Task task) {
        try {
            int rtn = onReceiveTask(task);
            if (rtn == 1) {
                // 判断task状态，是否需要执行exec
                if (!task.isThisComplete()) {
                    execTask(task);
                    saveStat(task, TaskConstant.TASK_STATUS.WAIT_SUB_COMPLETE);
                }
            } else {
                // 把状态记录下来，为什么没有执行，暂时只记录日志，后续需要体现到监控上
                task.setTask_status(rtn);
                ServiceLogs.debuglog(logtype,
                        String.format("onReceiveTask返回值[%d],不执行,Task.billno[%s]", rtn, task.getBillno()), 0);
            }
            taskManager.onExecComplete(task);
        } catch (Exception e) {
            taskManager.handleError(task, e);
        }

        return task.getTask_status();
    }

    private int onReceiveTask(Task task) {
        // 同步缓存或数据库中的task信息
        // 检查是否已经执行过，
        if (taskManager.taskIsExecCompleted(task)) {
            ServiceLogs.debuglog(logtype, "任务[{0}]已经执行过，不重复执行", 0, task.getBillno());
            return TaskConstant.TASK_STATUS.ALREADY_EXEC;
        }

        syncTaskInfo(task);
        return 1;
    }

    @Override
    public int execTask(Task task) {
        // 如果状态是未执行，则执行一波
        if (!task.isExecComplete()) {
            doExec(task);
        }
        // 创建子任务
        if (!task.isCreateSubComplete()) {
            saveStat(task, TaskConstant.TASK_STATUS.CREATE_SUB_START);
            if (executer instanceof TaskStreamCreateSubTask) {
                streamcreateSubTask(task);
            } else {
                createSubTask(task);
            }
            saveStat(task, TaskConstant.TASK_STATUS.CREATE_SUB_COMPLETE);

        }
        return ExecReturn.EXEC_STATUS.SUCESS.getValue();
    }

    private void streamcreateSubTask(Task task) {
        TaskStreamCreateSubTask create = (TaskStreamCreateSubTask) executer;
        create.createSubTask(task, new CreateSubTaskCallBack() {

            @Override
            public void callBack(Task subTask) {
                task.setTot_subtask_num(task.getTot_subtask_num() + 1);
                taskManager.save(subTask);
                taskManager.sendTask(subTask);
            }
        });
        ExecReturn rtn = ExecReturn.newSuccAndUptRtn("tot_subtask_num");
        task.setExecReturn(rtn);
    }

    private void createSubTask(Task task) {

        List<Task> listSubTask = doCreateSub(task);
        saveSubTaskList(listSubTask);
        ExecReturn rtn = ExecReturn.newSuccAndUptRtn("tot_subtask_num");
        saveStat(task, rtn, TaskConstant.TASK_STATUS.CREATE_SUB_SAVED);
        sendToNext(listSubTask);
    }

    private List<Task> doCreateSub(Task task) {
        List<Task> listSubTask = executer.createSubTask(task);
        if (listSubTask != null) {
            task.setTot_subtask_num(listSubTask.size());
        } else {
            task.setTot_subtask_num(0);
        }

        return listSubTask;
    }

    private void saveSubTaskList(List<Task> listSubTask) {
        taskManager.batchSave(listSubTask);
    }

    private void sendToNext(List<Task> listSubTask) {
        taskManager.sendTask(listSubTask);
    }

    private void doExec(Task task) {
        saveStat(task, TaskConstant.TASK_STATUS.EXEC_START);
        ExecReturn rtn = executer.execStep(task);
        saveStat(task, rtn, TaskConstant.TASK_STATUS.EXEC_COMPLETE);
    }

    private void syncTaskInfo(Task task) {
        taskManager.syncTaskInfo(task);
    }

    private void saveStat(Task task, ExecReturn rtn, int newStatus) {
        task.setExecReturn(rtn);
        taskManager.saveStat(task, newStatus);
    }

    private void saveStat(Task task, int newStatus) {
        taskManager.saveStat(task, newStatus);
    }

    @Override
    public void start() {

    }

    /**
     * 当所有任务完成后的回调方法
     */
    @Override
    public void onComplete(Task task) {
        try {
            executer.onComplete(task);
        } catch (Exception e) {
            ServiceLogs.errLog(logtype, e, "执行 billno[{0}],tasktype[{1}]的onComplete时发生错误:[{3}]", task.getBillno(),
                    task.getTask_type(), e.getMessage());
        }

    }

    @Override
    public TaskExecuter getTaskExecuter() {
        return this.executer;
    }

}
